<?php

class Youzify_Member_Types_Admin {

	public $field_name;

	function __construct() {

		// Set Licence Field Name
		$this->field_name = 'yz_member_types_license_key';

		// Add Settings Tab.
		add_filter( 'youzify_extensions_settings_menu', array( $this, 'settings_menu' ) );

		// Sync Member Type => Field Value.
		add_action( 'current_screen', array( $this, 'users_page_screen' ) );

		// Check for Updates.
		add_action( 'admin_init', array( $this, 'check_for_updates' ), 0 );

        // Add New Member Types Fields
        add_filter( 'bp_get_member_type_tax_labels', array( $this, 'add_new_member_types_fields' ) );

        // Add New Member Types Data
        add_filter( 'bp_get_type_metadata_schema', array( $this, 'get_type_metadata_schema' ), 10, 2 );

        // Save Member Types Fields Data.
        add_action( 'bp_type_inserted', array( $this, 'save_member_types_fields' ), 10 );
        add_action( 'bp_type_updated', array( $this, 'update_member_types_fields' ), 10, 2 );

        // Add Member Types Fields.
        add_action( 'bp_member_type_add_form_fields', array( $this, 'member_types_add_view' ), 99 );
        add_action( 'bp_member_type_edit_form_fields', array( $this, 'member_types_edit_view' ), 99 );

        // Save Restricted Tabs.
        add_action( 'bp_type_inserted', array( $this, 'save_new_restricted_types' ), 999 );
        add_action( 'bp_type_updated', array( $this, 'update_restricted_types' ), 999 );
        add_action( 'bp_type_deleted', array( $this, 'update_restricted_types' ), 999 );

    }

    public function save_member_types_fields( $result ) {

        // Save Right Color
        if ( isset( $_POST['youzify_type_associated_roles'] ) && ! empty( $_POST['youzify_type_associated_roles'] ) ) {
            add_term_meta( $result['term_id'], 'youzify_type_associated_roles', $_POST['youzify_type_associated_roles'], true );
        }

    }

    function update_member_types_fields( $term_id, $tt_id  ) {

        // Save Right Color
        if ( isset( $_POST['youzify_type_associated_roles'] ) && ! empty( $_POST['youzify_type_associated_roles'] ) ) {
            update_term_meta( $term_id, 'youzify_type_associated_roles', $_POST['youzify_type_associated_roles'] );
        } else {
            delete_term_meta( $term_id, 'youzify_type_associated_roles' );
        }

    }

    public function member_types_add_view( $taxonomy ) {

        ?>

        <div class="form-field bp-types-form">
            <label><?php _e( 'Associated Roles', 'youzify-member-types' ); ?></label>
            <p class="description"><?php _e( 'Member Type Associated Roles', 'youzify-member-types' ); ?></p>
            <?php foreach ( $this->get_site_roles() as $role => $name ) : ?>
                <label class="youzify-member-types-role">
                    <input type="checkbox" name="youzify_type_associated_roles[]" value="<?php echo $role; ?>" /> <?php echo $name; ?>
                </label>
            <?php endforeach; ?>
        </div>

        <?php

        // Scripts
        $this->member_types_scripts();


    }

    /**
     * Member Type
     */
    public function member_types_edit_view( $term ) { ?>

        <tr class="form-field bp-types-form">
            <th scope="row"><label><?php _e( 'Associated Roles', 'youzify-member-types' ); ?></label></th>
            <td>
            <?php $roles = get_term_meta( $term->term_id, 'youzify_type_associated_roles', true ); foreach ( $this->get_site_roles() as $role => $name ) : ?>
                <label class="youzify-member-types-role">
                    <input type="checkbox" name="youzify_type_associated_roles[]" value="<?php echo $role; ?>"  <?php if ( ! empty( $roles ) && in_array( $role, $roles ) ) echo 'checked="checked"'; ?>> <?php echo $name; ?>
                </label>
            <?php endforeach; ?>
            <p class="description"><?php _e( 'Member Type Associated Roles', 'youzify-member-types' ); ?></p>
            </td>
        </tr>

        <?php

        // Scripts
        $this->member_types_scripts();

    }

    /**
     * Scripts and Styles
     */
    function member_types_scripts() {

        ?>

        <style type="text/css">
            label.youzify-member-types-role {
                display: inline-block;
                min-width: 150px;
                margin-top: 5px;
            }
        </style>

        <?php

    }

    /**
     * Add New Member Types Fields
     */
    function add_new_member_types_fields( $fields ) {

        $fields['youzify_type_show_in_registration'] = _x( 'Display in Registration Form', 'Hide BP Member type from registration', 'youzify-member-types' );
        $fields['youzify_type_show_in_profile_settings'] = _x( 'Display in Profile Settings', 'Hide BP Member type from profile settings page', 'youzify-member-types' );
        $fields['youzify_type_exclude_from_members_directoy'] = _x( 'Exclude from Members Directory', 'BP Member type show in list', 'youzify-member-types' );
        $fields['youzify_type_roles'] = _x( 'Member Type Associated Roles', 'BP Member type associated roles', 'youzify-member-types' );
        $fields['youzify_type_icon'] = _x( 'Member Type Icon', 'BP Member type show in list', 'youzify-member-types' );
        $fields['youzify_type_bg_left_color'] = _x( 'Icon Background Left Color', 'BP Member type left color', 'youzify-member-types' );
        $fields['youzify_type_bg_right_color'] = _x( 'Icon Background Left Color', 'BP Member type left color', 'youzify-member-types' );

        return $fields;
    }

    /**
     * Add New Member Types Fields Data.
     */
    function get_type_metadata_schema( $schema = array(), $taxonomy = '' ) {

        if ( bp_get_member_type_tax_name() === $taxonomy ) {

            $schema['youzify_type_show_in_registration'] = array(
                'description'       => __( 'Show this member type in the registration form.', 'youzify-member-types' ),
                'type'              => 'boolean',
                'single'            => true,
                'sanitize_callback' => 'absint',
            );

            $schema['youzify_type_show_in_profile_settings'] = array(
                'description'       => __( 'Show this member type in the profile settings.', 'youzify-member-types' ),
                'type'              => 'boolean',
                'single'            => true,
                'sanitize_callback' => 'absint',
            );

            $schema['youzify_type_exclude_from_members_directoy'] = array(
                'description'       => __( 'Exclude members with this type from members directory.', 'youzify-member-types' ),
                'type'              => 'boolean',
                'single'            => true,
                'sanitize_callback' => 'absint',
            );

        }

        return $schema;
    }

	/**
	 * Add Settings Tab
	 */
	function settings_menu( $tabs ) {

		$tabs['member-types'] = array(
       	    'icon'  => 'fas fa-sitemap',
       	    'id'    => 'member-types',
       	    'function' => array( $this, 'settings' ),
       	    'title' => __( 'Member Types Settings', 'youzify-member-types' ),
        );

        return $tabs;

	}

    /**
     * # Custom Tabs Settings.
     */
    function settings() {

        global $Youzify_Settings, $Youzify_Admin;

		// Get License.
		$license = get_option( $this->field_name );

		if ( ! empty( $license ) ) {

            // Get License Status.
            $Youzify_Admin->get_license_status( array( 'license' => $license, 'option_id' => $this->field_name, 'product_id' => 64, 'position' => 'top' )  );

	        $Youzify_Settings->get_field(
	            array(
	                'title' => __( 'General Settings', 'youzify-member-types' ),
	                'type'  => 'openBox'
	            )
	        );

            $Youzify_Settings->get_field(
                array(
                    'title' => __( 'Multiple Member Types', 'youzify-member-types' ),
                    'desc'  => __( 'Allow users to select multiple member types', 'youzify-member-types' ),
                    'id'    => 'youzify_member_type_multiple',
                    'type'  => 'checkbox'
                )
            );

	        $Youzify_Settings->get_field(
	            array(
	                'title' => __( 'Enable Member Types Modification', 'youzify-member-types' ),
	                'desc'  => __( 'Enable users to edit the member type after registration', 'youzify-member-types' ),
	                'id'    => 'youzify_enable_member_types_modification',
	                'type'  => 'checkbox'
	            )
	        );

	        $Youzify_Settings->get_field(
	            array(
	                'title' => __( 'Display Member Types in Info Tab', 'youzify-member-types' ),
	                'desc'  => __( 'Show member types in the info tab', 'youzify-member-types' ),
	                'id'    => 'youzify_enable_member_types_in_infos',
	                'type'  => 'checkbox'
	            )
	        );

	        $Youzify_Settings->get_field(
	            array(
	                'title' => __( 'Allow Members with No Type', 'youzify-member-types' ),
	                'desc'  => __( 'Give the users the ability to stay with no member types', 'youzify-member-types' ),
	                'id'    => 'youzify_allow_no_member_type',
	                'type'  => 'checkbox'
	            )
	        );

            $Youzify_Settings->get_field(
                array(
                    'title' => __( 'No Member Type Roles', 'youzify-member-types' ),
                    'desc'  => __( 'No Member Type WordPress Roles', 'youzify-member-types' ),
                    'id'    => 'youzify_member_type_no_type_roles',
                    'opts'  => $this->get_site_roles(),
                    'type'  => 'checkboxes'
                )
            );

	        $Youzify_Settings->get_field( array( 'type' => 'closeBox' ) );

            $Youzify_Settings->get_field(
                array(
                    'title' => __( 'Registration Settings', 'youzify-member-types' ),
                    'type'  => 'openBox'
                )
            );

            $modal_args = array(
                'button_id' => 'youzify-add-member-type',
                'id'        => 'youzify-member-types-form',
                'title'     => __( 'Create New Member Type', 'youzify-member-types' )
            );

            $Youzify_Settings->get_field(
                array(
                    'title' => __( 'Enable Member Types While Registration', 'youzify-member-types' ),
                    'desc'  => __( 'Make member types selectable in the registration form', 'youzify-member-types' ),
                    'id'    => 'youzify_enable_member_types_registration',
                    'type'  => 'checkbox'
                )
            );

            $Youzify_Settings->get_field(
                array(
                    'title' => __( 'Set Default Members Type', 'youzify-member-types' ),
                    'desc'  => __( 'Works only if the the option above is disabled', 'youzify-member-types' ),
                    'id'    => 'youzify_default_member_type',
                    'opts'  => $this->member_types_drop_down(),
                    'type'  => 'select'
                )
            );

            $Youzify_Settings->get_field( array( 'type' => 'closeBox' ) );

	        // Get New Member Types Form.
	        // $this->modal( $modal_args, array( $this, 'form' ) );

	        // Get Member Types List.
	        // $this->get_types_list();

		}

        // Get License Settings.
        $Youzify_Admin->get_license_settings( array( 'license' => $license, 'option_id' => $this->field_name, 'product_id' => 64 )  );

    }

    /**
     * # Member Types Dropdown.
     */
    function member_types_drop_down() {

        // Get Var.
        $options = array();

        // Add default option
        $options[''] = __( '-- Select Default Type --', 'youzify-member-types' );

        // Get Member Types.
        $member_types = youzify_get_registration_member_types();

        if ( empty( $member_types ) ) {
            return $options;
        }

        foreach ( $member_types as $type_id => $member_type ) {

            // Get Option.
            $options[ $type_id ] = $member_type->labels['singular_name'];

        }

        return $options;

    }

    /**
     * Get Member Types List
     */
    function get_types_list() {

        global $Youzify_Settings;

        // Get Member Type Items
        $youzify_member_types = youzify_member_types_option( 'youzify_member_types' );

        ?>

        <script> var youzify_nextMType = <?php echo youzify_member_types_option( 'youzify_next_member_type_nbr', '1' ); ?>; </script>

        <div class="youzify-custom-section">
            <div class="youzify-cs-head">
                <div class="youzify-cs-buttons">
                    <button class="youzify-md-trigger youzify-member-types-button" data-modal="youzify-member-types-form">
                        <i class="fas fa-user-plus"></i>
                        <?php _e( 'Add New Member Type', 'youzify-member-types' ); ?>
                    </button>
                </div>
            </div>
        </div>

        <?php
    }

	/**
	 * Users Page Screen Actions.
	 **/
	function users_page_screen() {

		// Get Current Screen Page.
    	$current_screen = get_current_screen();

	    if ( $current_screen->id === 'users' ) {
			add_action( 'bp_set_member_type', array( $this, 'link_member_type_to_field_value' ), 10, 3 );
	    }
	}

	/**
	 * Sync Member Type => Field Value.
	 */
	function link_member_type_to_field_value( $user_id, $member_type, $append ) {

	    if ( ! is_admin() ) {
	        return;
	    }

	    // Get Filed ID.
	    $field_id = $this->get_xprofile_fields_by_type( 'member_types' );

	    if ( ! isset( $field_id[0] ) || empty( $field_id[0] ) ) {
	        return;
	    }

	    xprofile_set_field_data( $field_id[0], $user_id, $member_type );

        if ( empty( $member_type ) ) {

            if ( 'on' == youzify_member_types_option( 'youzify_allow_no_member_type', 'off' ) ) {

                // Assign No Member Type Role.
                if ( ! user_can( $user_id, 'manage_options' ) ) {

                    // Get No Member Type Result
                    $no_type_roles = get_option( 'youzify_member_type_no_type_roles' );

                    if ( ! empty( $no_type_roles ) ) {

                        // Get User.
                        $user = new WP_User( $user_id );

                        // Disable All Old Roles.
                        $user->set_role( '' );

                        // Assign Roles.
                        foreach ( $no_type_roles as $role ) {
                            $user->add_role( $role );
                        }

                    }

                }

            }
        } else {

            // Assign Roles.
            yzmt_assign_wordpress_roles( $user_id, $member_type );

        }
//         } else {
//         }

	}

    /**
     * Get Xprofile fields by field type.
     */
    function get_xprofile_fields_by_type( $fields_type ) {

        global $wpdb;

        // Get Fields Table Name.
        $fields_table = buddypress()->profile->table_name_fields;

        // Get Sql Query.
        $sql = "SELECT id FROM {$fields_table} WHERE type = %s";

        // Get Fields ID'S.
        $fields_ids = $wpdb->get_col( $wpdb->prepare( $sql, $fields_type ) );

        return $fields_ids;
    }

	/**
	 * Check For Updates.
	 */
	function check_for_updates() {

		// Get Licence.
		$license = get_option( $this->field_name );

		if ( empty( $license ) ) {
			return;
		}

        if ( ! class_exists( 'Youzify_Addons_Updater' ) ) {
            require YOUZIFY_MT_PATH . 'admin/panel/youzify-addons-updater.php';
        }

		// setup the updater
		$edd_updater = new YOUZIFY_Addons_Updater( YOUZIFY_STORE_URL, YOUZIFY_MT_FILE,
			array(
				'version' => YOUZIFY_MT_VERSION,
				'license' => $license,
				'item_id' => '64',
				'author'  => 'Youssef Kaine',
				'beta'    => false,
			)
		);

	}

    /**
     * Save Restricted Types from Members Directory.
     */
    function save_new_restricted_types( $result ) {

        if ( get_term_meta( $result['term_id'], 'youzify_type_exclude_from_members_directoy', true ) ) {

            // Get Term Data.
            $term = bp_get_term_by( 'id', $result['term_id'], 'bp_member_type' );

            // Get Restricted Types.
            $restricted_types = get_option( 'youzify_member_types_md_restricted_types' );

            if ( empty( $restricted_types ) ) {
                $restricted_types = array( $term->name );
            } else {
                $restricted_types[] = $term->name;
            }

            // Save Restricted Type
            update_option( 'youzify_member_types_md_restricted_types', $restricted_types );
        }

    }

    function update_restricted_types() {

        // Get Member Types
        $member_types = bp_get_member_types( array(), 'objects' );

        if ( ! empty( $member_types ) ) {

            $restricted_types = array();

            foreach ( $member_types as $type_id => $member_type ) {

                // youzify_log( $member_type );

                if ( get_term_meta( $member_type->db_id, 'youzify_type_exclude_from_members_directoy', true ) ) {
                    $restricted_types[] = $type_id;
                }
            }

            if ( ! empty( $restricted_types ) ) {
                update_option( 'youzify_member_types_md_restricted_types', $restricted_types );
            } else {
                delete_option( 'youzify_member_types_md_restricted_types' );
            }

        } else {
            delete_option( 'youzify_member_types_md_restricted_types' );
        }

    }

    /**
	 * Add Settings Tab Content
	 */
	// function save_settings( ) {

	//     // Save Member Types.
	//     if ( isset( $_POST['youzify_member_types_form'] ) ) {

 //     		// Member Types Options
	//     	$member_types = $_POST['youzify_member_types'];

 //            $types_roles = array();

 //            foreach ( $member_types as $type_id => $data ) {

 //                if ( isset( $data['roles'] ) && ! empty( $data['roles'] ) ) {
 //                    $types_roles[ $data['id'] ] = explode( ',', $data['roles'] );
 //                }

 //            }

 //            if ( ! empty( $types_roles ) ) {
 //                update_option( 'youzify_member_types_roles', $types_roles );
 //            } else {
 //                delete_option( 'youzify_member_types_roles' );
 //            }


	//     }

	// }


    /**
     * Get Site Roles
     */
    function get_site_roles() {

        $checkbox_roles = array();

        foreach ( get_editable_roles() as $id => $role ) {
            $checkbox_roles[ $id ] = $role['name'];
        }

        return apply_filters( 'youzify_get_site_roles', $checkbox_roles );

    }

}

new Youzify_Member_Types_Admin();
