<?php

get_header();
$aeiforia_project_category_taxonomy = get_taxonomy('aeiforia-project-category');
?>

<div id="content" class="aeiforia-archive blog-wrapper blog-single page-wrapper">

    <?php
        require_once __DIR__ . '/includes/aeiforia/module-top-section.php';
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-9 col">
        <?php
            if(flatsome_option('blog_style_archive') && (is_archive() || is_search())){
                get_template_part( 'template-parts/posts/archive', flatsome_option('blog_style_archive') );
            } else {              
                if ( $wp_query->have_posts() ) : ?>
                    <p class="lead" id="results">
                        <span style="display: inline-block;" title="<?php printf( _n( 'Showing %s project of %s projects', 'Showing %s of %s projects', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>"><?php echo __('There', 'erua') . ' ';  printf( _n( 'is %s project', 'are %s projects', $wp_query->found_posts, 'erua' ), '<strong>'.number_format_i18n( $wp_query->found_posts ).'</strong>' ); echo __(' in this category', 'erua'); ?></span>
                    </p>
                    <div id="post-list">

                    <?php /* Start the Loop */ ?>
                    <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>

                    <?php $categories_list = get_the_terms( get_the_ID(), 'aeiforia-project-category' ); ?>
                    
                    <article style="margin-bottom: 30px;" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                            <header class="entry-header">
                                <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                    <h6 class="entry-category is-xsmall">
                                        <?php
                                        if ( is_array($categories_list) ) {
                                            foreach($categories_list as $key => $category) {
                                                $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                            
                                                echo '<span><a href="' . site_url('/') . $aeiforia_project_category_taxonomy->rewrite['slug'] . '/' . $category->slug . '">'. $category->name .'</a></span>' . $separator;
                                            }
                                        }
                                        ?>
                                    </h6>

                                    <?php
                                    if ( is_single() ) {
                                        echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                                    } else {
                                        echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                                    }
                                    ?>

                                    <div class="entry-divider is-divider small"></div>

                                    <?php
                                    $single_post = is_singular( 'aeiforia-project' );
                                    if ( $single_post && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                        <div class="entry-meta uppercase is-xsmall">
                                            <?php flatsome_posted_on(); ?>
                                        </div>
                                    <?php elseif ( ! $single_post && 'aeiforia-project' == get_post_type() ) : ?>
                                        <div class="entry-meta uppercase is-xsmall">
                                            <?php flatsome_posted_on(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php if ( has_post_thumbnail() ) : ?>
                                    <?php if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                        <div class="entry-image relative">
                                            <?php get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                            <?php if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </header>
                            <?php get_template_part('template-parts/posts/content', 'default' ); ?>
                            <footer class="entry-meta clearfix">
                                <?php if ( 'aeiforia-project' == get_post_type() ) : // Hide category and tag text for pages on Search ?>
                                    <span class="cat-links">
                                        <?php
                                        echo __( 'Posted in ', 'erua' );
                                        if ( is_array($categories_list) ) {
                                            foreach($categories_list as $key => $category) {
                                                $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                            
                                                echo '<span><a href="' . site_url('/') . $aeiforia_project_category_taxonomy->rewrite['slug'] . '/' . $category->slug . '">'. $category->name .'</a></span>' . $separator;
                                            }
                                        }
                                        ?>
                                    </span>

                                    <?php
                                        /* translators: used between list items, there is a space after the comma */
                                        $tags_list = get_the_tag_list( '', __( ', ', 'flatsome' ) );
                                        if ( $tags_list ) :
                                    ?>
                                    <span class="sep">&nbsp;|&nbsp;</span>
                                    <span class="tags-links">
                                        <?php printf( __( 'Tagged %1$s', 'flatsome' ), $tags_list ); ?>
                                    </span>
                                    <?php endif; // End if $tags_list ?>
                                <?php endif; // End if 'post' == get_post_type() ?>

                                <?php if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
                                <span class="comments-link pull-right"><?php comments_popup_link( __( 'Leave a comment', 'flatsome' ), __( '<strong>1</strong> Comment', 'flatsome' ), __( '<strong>%</strong> Comments', 'flatsome' ) ); ?></span>
                                <?php endif; ?>
                            </footer>
                        </div>
                    </article>

                    <?php endwhile; ?>

                    <?php flatsome_posts_pagination(); ?>

                    </div>

                    <?php else : ?>

                        <?php get_template_part( 'template-parts/posts/content','none'); ?>
  
                    <?php endif;
            }
        ?>
        </div>
        <div class="post-sidebar large-3 col">
            <?php flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php flatsome_sidebar_classes(); ?>" role="complementary">
                <?php do_action( 'before_sidebar' ); ?>
                <?php if ( ! dynamic_sidebar( 'aeiforia-sidebar' ) ) : ?>
                <?php endif; // end sidebar widget area ?>
            </div>
            <?php flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div>
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
