<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Disable BuddyPress User Personal Data Export Setting
 * https://buddydev.com/disable-buddypress-user-personal-data-export-setting/
 */
add_filter( 'bp_settings_show_user_data_page', '__return_false' );

/**
 * Register member types
 * https://codex.buddypress.org/developer/member-types/
 */
function bbg_register_member_types() {
    bp_register_member_type( 'creative-eruaner', array(
        'labels' => array(
            'name'          => 'Creative ERUAners',
            'singular_name' => 'Creative ERUAner',
        ),
    ) );
}
//add_action( 'bp_register_member_types', 'bbg_register_member_types' );

/**
 * Add "OpenID Connect" login option, to the login form.
 * 
 * See youzify\includes\public\core\membership\class-youzify-form.php
 */
function openid_login_form() {
    echo do_shortcode('[openid_connect_generic_login_button]');
}
//add_action( 'youzify_before_login_form', 'openid_login_form' );
//add_action( 'youzify_after_login_form', 'openid_login_form' );
//add_action( 'youzify_after_login_fields', 'openid_login_form' );
add_action( 'youzify_before_login_fields', 'openid_login_form' );

//-------------------------------------------------------------------
// SHORTCODES
//-------------------------------------------------------------------

/**
 * Youzify - BuddyPress Quick Buttons to Main Navigation
 * 
 * https://kainelabs.ticksy.com/article/16521/
 * https://stackoverflow.com/questions/31812132/buddypress-display-notification-and-profile-in-header-instead-of-wp-admin-bar
 * https://wordpress.stackexchange.com/questions/44736/programmatically-add-a-navigation-menu-and-menu-items/220107#220107
 */
function get_user_quick_buttons_shortcode() {

    $output = '';
    ob_start();

    if ( is_user_logged_in() && function_exists('bp_is_active') ) :

        $user_id = get_current_user_id();
        $user_id = ! empty( $user_id ) ? $user_id : bp_loggedin_user_id();
    ?>

    <div class="youzify-quick-buttons">

        <?php if ( bp_is_active( 'friends' ) ) : ?>

            <?php

                // Get Buttons Data
                $friends_url = bp_loggedin_user_domain() . bp_get_friends_slug();
                $friend_requests = bp_friend_get_total_requests_count( $user_id );

            ?>

            <a href="<?php echo $friends_url . '/requests'; ?>" class="youzify-button-item youzify-friends-btn">
                <span class="dashicons dashicons-groups"></span>
                <?php if ( $friend_requests > 0 ) : ?>
                    <div class="youzify-button-count"><?php echo $friend_requests; ?></div>
                <?php endif; ?>
            </a>

        <?php endif; ?>

        <?php if ( bp_is_active( 'messages' ) ) : ?>

            <?php $msgs_nbr = bp_get_total_unread_messages_count( $user_id ); ?>

            <a href="<?php echo bp_nav_menu_get_item_url( bp_get_messages_slug() ); ?>" class="youzify-button-item youzify-messages-btn">
                <span class="dashicons dashicons-email-alt"></span>
                <?php if ( $msgs_nbr > 0 ) : ?>
                <div class="youzify-button-count"><?php echo $msgs_nbr; ?></div>
                <?php endif; ?>
            </a>

        <?php endif; ?>

        <?php if ( bp_is_active( 'notifications' ) ) : ?>

            <?php $notification_nbr = bp_notifications_get_unread_notification_count( $user_id ); ?>

            <a href="<?php echo bp_nav_menu_get_item_url( bp_get_notifications_slug() ); ?>" class="youzify-button-item youzify-notification-btn">
                <i class="fa-solid fa-bell"></i>
                <?php if ( $notification_nbr > 0 ) : ?>
                <div class="youzify-button-count"><?php echo $notification_nbr; ?></div>
                <?php endif; ?>
            </a>

        <?php endif; ?>

    </div>
    <?php
    endif;

    $output = ob_get_contents();
    ob_end_clean();
    return $output;
}
add_shortcode( 'get_user_quick_buttons', 'get_user_quick_buttons_shortcode' );

/**
 * Youzify - BuddyPress Add User Account to Main Navigation
 * https://gist.github.com/KaineLabs/11e7fcf07cada40c4dfe53df7e76cc5c
 */
function get_user_menu_shortcode() {

    $output = '';
    ob_start();

    if ( is_user_logged_in() && function_exists('bp_is_active') ) :

        $user_id = get_current_user_id();
        $user_id = ! empty( $user_id ) ? $user_id : bp_loggedin_user_id();
        $user_content_page_id = get_field('my_content_page', 'option') ?? '';

        //require_once WP_PLUGIN_DIR . '/youzify/includes/public/core/class-youzify-profile.php';
        //$instance = "Youzify_Profile"::get_instance();
        ?>

        <?php if ( apply_filters( 'youzify_display_user_profile_quick_menu', true ) ):  ?>
            <li class="account-item has-icon has-dropdown">
                <a href="<?php echo bbp_get_user_profile_url( bp_loggedin_user_id() ); ?>" class="account-link circle" title="<?php echo __('My Profile', 'erua') . ' ' . 
bp_current_action(); ?>">
                <?php echo bp_core_fetch_avatar( array( 'item_id' => bp_loggedin_user_id(), 'type' => 'thumb', 'width' => 35, 'height' => 35 ) ); ?><i class="fas fa-angle-down youzify-settings-icon" aria-hidden="true"></i></a>
            <?php //$instance->user_settings_menu(); ?>
            <?php

            // New Array
            $links = array();
            $is_xprofile_active = bp_is_active( 'xprofile' );
            $is_settings_active = bp_is_active( 'settings' );

            // Profile Settings
            if ( $is_xprofile_active ) {

                $links['profile'] = array(
                    'icon'	=> 'fas fa-user',
                    'href'	=> youzify_get_profile_settings_url( false, $user_id ),
                    'title'	=> __( 'Profile Settings', 'youzify' ),
                    'action'  => 'profile'
                );

            }

            // Account Settings
            if ( $is_settings_active ) {
                $links['account'] = array(
                    'icon'	=> 'fas fa-cogs',
                    'href'	=> bp_core_get_user_domain( $user_id ) . bp_get_settings_slug(),
                    'title'	=> __( 'Account Settings', 'youzify' ),
                    'action'  => 'settings'
                );
            }

            // Widgets Settings
            if ( apply_filters( 'youzify_create_widgets_settings_page', true ) ) {
                $links['widgets'] = array(
                    'icon'	=> 'fas fa-sliders-h',
                    'href'	=> youzify_get_widgets_settings_url( false, $user_id ),
                    'title'	=> __( 'Widgets Settings', 'youzify' ),
                    'action'  => 'widgets'
                );
            }

            if ( $is_xprofile_active ) {

                // Change Photo Link
                $links['change-photo'] = array(
                    'icon'	=> 'fas fa-camera-retro',
                    'href'	=> youzify_get_profile_settings_url( 'change-avatar', $user_id ),
                    'title'	=> __( 'Change Avatar', 'youzify' ),
                    'action'  => 'change-avatar'
                );
            }

            if ( $user_content_page_id && $mycontent_page_slug = get_post_field( 'post_name', $user_content_page_id ) ) {
                $links['view-your-content'] = array(
                    'icon'	=> 'fa-solid fa-file-signature',
                    'href'	=> site_url($mycontent_page_slug . '/'),
                    'title'	=> __( 'My Content', 'youzify' ),
                    'action'  => 'view-your-content'
                );
            }

            // if ( $is_settings_active ) {

            //     // Change Password Link
            //     $links['change-password'] = array(
            //         'icon'	=> 'fas fa-lock',
            //         'href'	=> bp_core_get_user_domain( $user_id ) . bp_get_settings_slug() . '/general',
            //         'title'	=> __( 'Change Password', 'youzify' ),
            //         'action'  => 'settings-password'
            //     );

            // }

            // Logout Link
            $links['logout'] = array(
                'icon'	=> 'fas fa-power-off',
                'href'	=> wp_logout_url(),
                'title'	=> __( 'Logout', 'youzify' )
            );

            // Filter.
            $links = apply_filters( 'youzify_get_profile_account_menu', $links, $user_id );

            $found_active = null;
            ?>

                <ul class="nav-dropdown nav-dropdown-simple" style="">
                    <?php foreach ( $links as $link ) : ?>
                    <li class="erua-MyAccount-navigation-link<?php echo ( isset($link['action']) && ( ( 'view-your-content' === $link['action'] && $user_content_page_id === get_queried_object_id() ) || (bp_current_component() === $link['action'] || bp_current_action() === $link['action']) ) ) ? ' active' : ''; ?>">
                        <a href="<?php echo esc_url( $link['href'] ); ?>">
                            <i class="<?php echo $link['icon'];?>" style="display: inline-block; width: 25px; margin-right: 5px; text-align: center;"></i> <span class="youzify-button-title"><?php echo $link['title']; ?></span>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </li>

            <?php endif; ?>

        <?php
        else :
                return;
        endif;

        $output = ob_get_contents();
        ob_end_clean();
        return $output;
}
add_shortcode( 'get_user_menu', 'get_user_menu_shortcode' );



//-------------------------------------------------------------------
// MEMBERS DIRECTORY
//-------------------------------------------------------------------

// Member Types
// https://kainelabs.ticksy.com/articles/100012863

// https://stackoverflow.com/questions/22413548/buddypress-members-directory-page

//-------------------------------------------------------------------
// AJAX icons
//-------------------------------------------------------------------

// https://buddypress.org/support/topic/new-message-ajax-notifiction/
// https://stackoverflow.com/questions/9356436/buddy-press-ajax-new-message-notifiction
// https://stackoverflow.com/questions/66893938/frontend-buddypress-notifications-show-for-current-user-only
// https://gist.github.com/itsmereal/7121132

//-------------------------------------------------------------------
// PMs
//-------------------------------------------------------------------

// Rate limit them
// https://www.buddyboss.com/resources/docs/integrations/buddypress-add-ons/buddypress-private-message-rate-limiter/

// Better (live) interface
// https://wordpress.org/plugins/bp-better-messages/

// Members list add PM button
// https://buddydev.com/add-send-private-message-button-in-members-directory-on-a-buddypress-network/

//-------------------------------------------------------------------
// OTHER
//-------------------------------------------------------------------

// https://buddypress.org/support/topic/how-do-i-detect-whether-im-on-a-buddypress-page/

// Give Verified Badge After BuddyPress Members Complete Their Profile 
// https://www.youtube.com/watch?v=VuKCilnF16E

// https://youzify.com/buddypress-addons/
// https://youzify.com/downloads/buddypress-activity-reactions/

// Disable Widgets settings
// https://gist.github.com/KaineLabs/3b372c3a1297af8840264d4481259e08

// Custom Widget Class - Duplicated Skills Example. <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// https://gist.github.com/KaineLabs/23e4a89947e9fda2e62ab5266b4fc30b

// https://gist.github.com/KaineLabs
// https://www.youtube.com/watch?v=RLAKevQjpW8&list=PLlgSvQqMfii4KGpnRtALo7B_oPLwwINwd&index=4

//-------------------------------------------------------------------
// BBPRESS
//-------------------------------------------------------------------

// bbPress plugins:
// https://www.youtube.com/watch?v=foT0K0rJtak&t=1831s


