<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// Build the Breadcrumb trail.
//================================================================================

$breadcrumbs = [];
$eruahaus_landing_page_id = ( get_field('eruahaus_landing_page', 'option') ) ?? null;
$eruahaus_showroom_page_id = ( get_field('eruahaus_showroom_page', 'option') ) ?? null;

// (1) Add the Site's home page to the breadcrumb trail
$breadcrumbs[] = [
    get_site_url(),
    __('Home', 'erua')
];

// (2) Add Module Root
if ( $eruahaus_landing_page_id ) {
    // Add the Site's home page to the breadcrumb trail
    $breadcrumbs[] = [
        get_permalink($eruahaus_landing_page_id),
        get_the_title($eruahaus_landing_page_id)
    ];
}

// (3) Add current view
if ( ! is_tax() && ! is_archive() && ! is_singular(['eruahaus-project', 'showroom']) && $eruahaus_landing_page_id !== get_the_ID() ) {

    if ( $eruahaus_showroom_page_id == get_the_ID() ) {
        $page_title = __('ShowRoom', 'erua');
        $breadcrumbs[] = [
            get_permalink($eruahaus_showroom_page_id),
            $page_title
        ];
    }
    else {
        $breadcrumbs[] = [
            get_permalink(get_the_ID()),
            get_the_title(get_the_ID())
        ];
    }

}
else if ( is_singular('eruahaus-project') ) {
    $eruahaus_project_focus_area_taxonomy = get_taxonomy('eruahaus-project-focus-area');
    $project_category = get_the_terms( get_the_ID(), 'eruahaus-project-focus-area' );
    if ( $project_category ) {
        $breadcrumbs[] = [
            get_site_url() . '/' . $eruahaus_project_focus_area_taxonomy->rewrite['slug'] . '/' . $project_category[0]->slug,
            $project_category[0]->name
        ];
    }

    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_singular('showroom') ) {
    $eruahaus_showroom_page_id = ( get_field('eruahaus_showroom_page', 'option') ) ?? null;

    if ( $eruahaus_showroom_page_id ) {
        $breadcrumbs[] = [
            get_permalink($eruahaus_showroom_page_id),
            __('ShowRoom', 'erua')
        ];
    }

    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_tax(['showroom-category', 'showroom-tag']) ) {
    $filters = [];
    if ( $showroom_category_filter && isset($_GET['showroom_category']) ) {
        $filters['showroom_category'] = filter_input(INPUT_GET, 'showroom_category', FILTER_SANITIZE_URL);
    }
    if ( $showroom_tag_filter && isset($_GET['showroom_tag']) ) {
        $filters['showroom_tag'] = filter_input(INPUT_GET, 'showroom_tag', FILTER_SANITIZE_URL);
    }

    $query_string = http_build_query($filters);
    $query_string = ( empty($query_string) ) ? '' : '?'.$query_string;

    $eruahaus_showroom_page_id = ( get_field('eruahaus_showroom_page', 'option') ) ?? null;

    if ( $eruahaus_showroom_page_id ) {
        $breadcrumbs[] = [
            get_permalink($eruahaus_showroom_page_id),
            get_the_title($eruahaus_showroom_page_id)
        ];
    }

    $current_term_object = $wp_query->get_queried_object();
    $current_taxonomy = get_taxonomy($current_term_object->taxonomy);
    $page_title = $current_taxonomy->labels->singular_name . ': ' . $current_term_object->name;
    $page_url = get_permalink(get_the_ID());

    $breadcrumbs[] = [
        $page_url . $query_string,
        $page_title
    ];
}
else if ( is_tax(['creative-blog-category', 'creative-blog-tag']) ) {
    $current_term_object = $wp_query->get_queried_object();
    $current_taxonomy = get_taxonomy($current_term_object->taxonomy);
    $page_title = $current_taxonomy->labels->singular_name . ': ' . $current_term_object->name;

    $breadcrumbs[] = [
        get_post_type_archive_link('creative-blog-post'),
        __('Creative Blog', 'erua')
    ];

    $breadcrumbs[] = [
        get_site_url() . '/' . $current_taxonomy->rewrite['slug'] . '/' . $current_term_object->slug,
        $page_title
    ];
}
else if ( is_tax() ) {
    $current_term_object = $wp_query->get_queried_object();
    $current_taxonomy = get_taxonomy($current_term_object->taxonomy);
    $page_title = $current_taxonomy->labels->singular_name . ': ' . $current_term_object->name;

    $breadcrumbs[] = [
        get_site_url() . '/' . $current_taxonomy->rewrite['slug'] . '/' . $current_term_object->slug,
        $page_title
    ];
}
else if ( is_archive('eruahaus-project') ) {
    $page_title = get_the_archive_title();
    $breadcrumbs[] = [
        get_post_type_archive_link('eruahaus-project'),
        $page_title
    ];
}
else if ( is_archive('creative-blog-post') ) {
    $page_title = get_the_archive_title();
    $breadcrumbs[] = [
        get_post_type_archive_link('creative-blog-post'),
        $page_title
    ];
}

//================================================================================
// Build the Module Title.
//================================================================================

$title = ( ! is_tax() && ! is_archive() && $eruahaus_showroom_page_id !== get_the_ID() ) ? get_the_title(get_the_ID()) : $page_title;

?>
<section class="module-top section eruahaus" style="padding-bottom: 0; z-index: 2;">
    <div class="bg section-bg fill bg-fill bg-loaded"></div>
    <div class="section-content relative">
        <div class="row row-full-width">
            <div class="col small-12 large-12" style="padding-bottom: 0;">
                <div class="col-inner">
                    <ol class="breadcrumb">
                        <?php foreach( $breadcrumbs as $breadcrumb ) : ?>
                        <li class="breadcrumb-item"><a href="<?php echo $breadcrumb[0]; ?>"><span><?php echo $breadcrumb[1]; ?></span></a></li>
                        <?php endforeach; ?>
                    </ol>
                    <div class="module-title"><h3 class="module-heading"><?php echo $title; ?></h3></div>
                    <?php echo do_shortcode('[eruahaus_menu]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>