<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Enqueue scripts that change the ShowRoom listings data via AJAX.
 */
function erua_enqueue_showroom_search_script() {

    global $post;
    //global $wp;

    $showroom_page_id = ( get_field('eruahaus_showroom_page', 'option') ) ?? null;

    /**
     * If @ ERUAHAUS ShowRoom page
     */
    if ( $post && $showroom_page_id && $showroom_page_id === intval($post->ID) ) {

        // Enqueue the script in the footer!
        wp_enqueue_script('erua-ajax-search-showroom', get_stylesheet_directory_uri() . '/assets/js/ajax-search-showroom.js', '', '', true);

        global $wp_query;
        $qvars = $wp_query->query;
        //$qvars['testing'] = 'hmm';
        // Push the query vars to the above script
        wp_localize_script('erua-ajax-search-showroom', 'ajax_query_data', ['query' => $qvars]);

        $params = [
            '_ajax_url' => admin_url('admin-ajax.php'),
            '_ajax_action' => 'the_eruahaus_showroom_search', # load function hooked to: "wp_ajax_*" action hook
            //'_ajax_post_id' => get_the_ID(),
            /**
             * The nonce is generated based on the current time, 
             * the provided string argument, and the current user ID.
             * https://codex.wordpress.org/Function_Reference/wp_create_nonce
             */
            '_ajax_nonce' => wp_create_nonce('showroom_filtering_nonce'),
        ];
        // Additionally push some necessary variables to the script
        wp_localize_script('erua-ajax-search-showroom', 'ajax_object', $params);

    }

}
add_action('wp_enqueue_scripts', 'erua_enqueue_showroom_search_script', 100);

//================================================================================
// AJAX ACTIONS.
//================================================================================

/**
 * This function filters ShowRoom listings via AJAX.
 */
function erua_ajax_search_showroom() {

    /*-------------------------------------------------------------------
        SECURITY
    -------------------------------------------------------------------*/

    /**
     * If the nonce is not set or incorrect, then check_ajax_referrer() 
     * will cause the AJAX call to die, protecting your AJAX call from invalid requests.
     * 
     * https://codex.wordpress.org/WordPress_Nonces
     */
    //check_ajax_referer('showroom_filtering_nonce', 'ajaxnonce');
    if ( ! check_ajax_referer('showroom_filtering_nonce', 'ajaxnonce') ) {
        wp_send_json_error();
    }

    // Note: Consider implementing some throttling mechanism to limit AJAX requests?
    // https://stackoverflow.com/questions/7082527/jquery-throttling-and-queuing-of-ajax-requests

    /*-------------------------------------------------------------------
        DEBUG FORM DATA
    -------------------------------------------------------------------*/

    // $html = '';
    // ob_start();

    // echo '<pre>';
    // var_dump($_POST['form_data']);
    // echo '</pre>';

    // $html = ob_get_contents();
    // ob_end_clean();

    // $response = [
    //     'html' => $html,
    // ];
    // wp_send_json_success($response);
    // die();

    /*-------------------------------------------------------------------
        GATHER ALL $_POST DATA
    -------------------------------------------------------------------*/

    $ajax_showroom_category = null;
    //$ajax_keyword_search = null;

    if ( isset($_POST['form_data']['field_65602eff71acc']) ) {
        $ajax_showroom_category = filter_var_array($_POST['form_data']['field_65602eff71acc'], FILTER_VALIDATE_INT);
        if ( count($ajax_showroom_category) === 1 && $ajax_showroom_category[0] === false ) $ajax_showroom_category = null;
    }
    // if ( isset($_POST['form_data']['field_65514d0a8f244']) ) {
    //     $ajax_keyword_search = ( strlen($_POST['form_data']['field_65514d0a8f244'][0]) >=3 ) ? $_POST['form_data']['field_65514d0a8f244'][0] : null;
    // }
    // if ( isset($_POST['form_data']['field_65514d1a8f249']) ) {
    //     $ajax_project_funding_sources = filter_var_array($_POST['form_data']['field_65514d1a8f249'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    // }

    $ajax_taxonomy = filter_var($_POST['form_data']['_ajax_taxonomy'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_taxonomy_rewrite_slug = filter_var($_POST['form_data']['_ajax_taxonomy_rewrite_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    //$ajax_showroom_category = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    //$query_args = filter_input(INPUT_POST, 'query_args', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
    $ajax_original_url = filter_var($_POST['form_data']['_ajax_original_page_url'], FILTER_VALIDATE_URL);
    $ajax_original_term_slug = filter_var($_POST['form_data']['_ajax_original_page_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_original_term_id = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    /*-------------------------------------------------------------------
        PROCESS DATA
    -------------------------------------------------------------------*/

    $showroom_category_ids = [];

    // Find all available ShowRoom category terms
    $all_categories = get_terms( [ 'taxonomy' => 'showroom-category', 'hide_empty' => false ] );

    foreach ( $all_categories as $cat ) {
        array_push($showroom_category_ids, $cat->term_id);
    }

    // A provided ShowRoom category can only be an existing showroom-category taxonomy
    if ( !empty($ajax_showroom_category) ) {
        foreach( $ajax_showroom_category as $cat ) {
            if ( !in_array( (int) $cat, $showroom_category_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    /*-------------------------------------------------------------------
        SET QUERY VARS
    -------------------------------------------------------------------*/

    $filters = [];

    if ( !empty($ajax_showroom_category) && $ajax_taxonomy !== 'showroom-category' ) {
        $temp = implode( ',', $ajax_showroom_category );
        set_query_var( 'showroom_category', $temp );
        $filters['showroom_category'] = $temp;
    }
    //set_query_var('paged', 0);

    $query_string = http_build_query($filters);
    $query_string = ( empty($query_string) ) ? '?viewing=all' : '?'.$query_string;

    // If there is an AJAX-provided "viewing" filter, select it.
    //$ajax_filter = (!empty($query_args['viewing' ])) ? $query_args['viewing' ] : 'default';

    /*-------------------------------------------------------------------
        HANDLE PAGINATION
    -------------------------------------------------------------------*/

    /**
     * In order for pagination to work, we need to build again the base URL path.
     * The site_url() gets prepended automatically to the base.
     * 
     * Thus, if our base is "something/mypage/",
     * the base will become "https://mydomain/something/mypage/",
     * and pagination path will be appended to that e.g. "https://mydomain/something/mypage/page/x/"
     * 
     * // https://stackoverflow.com/questions/20150653/wordpress-pagination-not-working-with-ajax
     */
    $path = ( empty($ajax_taxonomy) )
    ? $ajax_original_term_slug . '/'
    : $ajax_taxonomy_rewrite_slug . '/' . $ajax_original_term_slug . '/';

    $base = $path . $query_string;

    $original_req_uri = $_SERVER['REQUEST_URI']; # "/wp-admin/admin-ajax.php"

    /**
     * Overwrite the REQUEST_URI variable on which 
     * pagination ("get_pagenum_link()") depends on in order to build its links
     */
    $_SERVER['REQUEST_URI'] = $base;

    /*-------------------------------------------------------------------
        BUILD NEW QUERY & RENDER THE NEW CONTENT
    -------------------------------------------------------------------*/

    /**
     * The security checks have passed 
     * and the user is allowed to run the specified query.
     * Create a new query!
     */
    $new_query_args = getShowRoomQueryArguments($ajax_showroom_category, null);

    // Will reset previous WP Query and clear all query vars!
    wp_reset_query();
    $wp_query = new WP_Query($new_query_args);

    $showroom_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
    $showroom_taxonomies['showroom-category'] = get_taxonomy('showroom-category');
    $showroom_taxonomies['showroom-tag'] = get_taxonomy('showroom-tag');

    $html = '';
    ob_start();

    include_once __DIR__ . '/presentation-listings-content.php';

    // echo '<pre>';
    // var_dump($new_query_args);
    // echo '</pre>';

    $html = ob_get_contents();
    ob_end_clean();

    // Restore the original REQUEST_URI - in case anything else would resort on it
    $_SERVER['REQUEST_URI'] = $original_req_uri;

    /*-------------------------------------------------------------------
        SEND RESPONSE
    -------------------------------------------------------------------*/
    $response = [
        'html' => $html,
        'query_string' => $query_string,
        'wp_query_args' => $new_query_args,
        'base_url' => $path,
        'results' => $wp_query->post_count
    ];
    wp_send_json_success($response);
    die(); // required. to end AJAX request.
}
// handling ajax action for logged-in users and guests
add_action('wp_ajax_the_eruahaus_showroom_search', 'erua_ajax_search_showroom');
add_action('wp_ajax_nopriv_the_eruahaus_showroom_search', 'erua_ajax_search_showroom');
