<?php
/**
 * Styling file inputs:
 * https://tympanus.net/codrops/2015/09/15/styling-customizing-file-inputs-smart-way/
 * 
 * ACF Dropzone plugin ("Enable Drag and Drop Upload in ACF’s Image, File and Gallery Field"):
 * https://wordpress.org/plugins/acf-dropzone/
 */
?>
<script>
document.addEventListener('DOMContentLoaded', function(event) {

    const mediaFileUploader = document.querySelector('#event-programme-agenda .acf-file-uploader');
    const fileUploadArea = document.querySelector('#event-programme-agenda .acf-basic-uploader');
    const mediaFileInput = document.getElementById('acf-field_65aaf8a8b8410');

    // ----- On render -----
    fileUploadArea.classList.add('dragging');
    fileUploadArea.classList.remove('dragging');

    /*-------------------------------------------------------------------
        FILE SIZE AND TYPE RESTRICTIONS
    -------------------------------------------------------------------*/

    //let accept = mediaFileInput.getAttribute('accept').split(',');
    //let accept = mediaFileUploader.getAttribute('data-mime_types').split(',');
    //accept = accept.map(function(s) { return s.trim() });
    let accept = null;
    let sizeLimit = 20971520; // MB
    let allowedMimeTypes = accept || ['application/pdf', 'application/x-pdf', 'application/acrobat'];

    /*-------------------------------------------------------------------
        LABEL INIT
    -------------------------------------------------------------------*/

    jQuery( fileUploadArea ).append('<svg viewBox="0 0 190 50"><use href="<?php echo site_url('/wp-content/uploads/2024/01/file-upload-document.svg#file-upload'); ?>"></use></svg><span><?php _e('upload your programme agenda','erua'); ?></span>');

    /*-------------------------------------------------------------------
        FILE INPUT
    -------------------------------------------------------------------*/

    jQuery( mediaFileInput ).each( function() {

        var input	 = jQuery( this ),
            label	 = input.closest( 'label' ),
            // store the default value of the label to bring it back when necessary
            //labelVal = label.html();
            labelSpan = label.find( 'span' );
            labelSpanVal = labelSpan.html();

        input.on( 'change', function( e )
        {
            //console.log('on change event fired');
            var fileName = '';

            if ( this.files && this.files.length > 1 ) {
                //console.log('case 1');
                fileName = ( this.getAttribute( 'data-multiple-caption' ) || '' ).replace( '{count}', this.files.length );
            }
            else if ( e.target.value ) {
                //console.log('case 2');
                fileName = e.target.value.split( '\\' ).pop();
            }
            else {
                //console.log('case 3');
                //label.html( labelVal );
            }

            // display the filename if there is one, otherwise restore the original label
            if ( fileName ) {
                //console.log('case 4');
                //label.find( 'span' ).html( fileName );
                labelSpan.html( fileName );
            }
            else {
                //console.log('case 5');
                //label.html( labelVal );
                labelSpan.html( labelSpanVal );
            }
        });

        // input.on( 'blur', function( e )
        // {
        //     console.log('on blur event fired');
        // });

        // input.on( 'click', function( e )
        // {
        //     console.log('on click event fired');
        // });

        // Firefox bug fix
        input
        .on( 'focus', function() { input.addClass( 'has-focus' ); })
        .on( 'blur', function() { input.removeClass( 'has-focus' ); });
    });

    /*-------------------------------------------------------------------
        DRAGGING AND DROPPING
    -------------------------------------------------------------------*/
    function handlerFunction(e) {
        e.preventDefault();
        e.stopPropagation();

        if ( ! fileUploadArea.classList.contains('dragging') ) {
            fileUploadArea.classList.add('dragging');
        }
    }

    fileUploadArea.addEventListener('dragstart', e => {
        e.dataTransfer.setData("text", "data");
        e.dataTransfer.effectAllowed = "move";
    });

    fileUploadArea.addEventListener('dragenter', function(e) { handlerFunction(e); }, false);
    fileUploadArea.addEventListener('dragover', function(e) { handlerFunction(e); }, false);
    fileUploadArea.addEventListener('dragleave', function(e) {
        e.preventDefault();
        e.stopPropagation();

        if ( e.type === 'dragover' ) {
            e.dataTransfer.effectAllowed = "move";
        }

        if ( fileUploadArea.classList.contains('dragging') ) {
            fileUploadArea.classList.remove('dragging');
        }

    }, false);

    <?php
    /**
     * Possible Firefox bug with null e.dataTransfer
     * https://www.anycodings.com/1questions/791884/firefox-ondrop-eventdatatransfer-is-null-after-update-to-version-52
     * 
     * Note: the 'drop' event does not trigger the input's 'change' event,
     * therefore we need to duplicate all the necessary logic in both events.
     */
    ?>
    fileUploadArea.addEventListener('drop', function(e) {
        e.preventDefault();
        //e.stopPropagation();

        // This will get the current data value dropped as a string
        let textData = e.dataTransfer.getData("text");

        //alert('dropped');
        //console.log(e.dataTransfer);
        //console.log(textData);

        fileUploadArea.classList.remove('dragging');

        <?php
        /**
         * https://stackoverflow.com/questions/16674963/event-originalevent-jquery
         * https://stackoverflow.com/questions/29798010/detect-whether-an-event-is-triggered-by-user-and-not-programmatically
         * https://stackoverflow.com/questions/33420306/drag-drop-datatransfer-object
         */
        ?>
        if (e.isTrusted) {
            // Keep in mind that files is not an array, but a FileList
            var file = e.dataTransfer.files[0];

            //alert(e.dataTransfer.files[0]);
            //alert(file.type);

            //if ( file.size >= 25 && file.size <= sizeLimit && allowedMimeTypes.includes(file.type) ) {

                mediaFileInput.files = e.dataTransfer.files;
                //console.log(file);

                //console.log(mediaFileInput.files);

                var reader = new FileReader();

                reader.readAsDataURL(file);
                reader.onload = function(e) {
                    //console.log(reader.result);
                    //fileUploadArea.style.backgroundImage = 'url(' + reader.result + ')';
                    //fileUploadArea.classList.add('hasImage');

                    var input	 = jQuery( mediaFileInput ),
                        label	 = input.closest( 'label' ),
                        labelSpan = label.find( 'span' );
                        labelSpanVal = '<?php _e('upload your programme agenda','erua'); ?>';

                        var fileName = '';

                        if ( mediaFileInput.files && mediaFileInput.files.length > 1 ) {
                            //console.log('case 1');
                            fileName = ( mediaFileInput.getAttribute( 'data-multiple-caption' ) || '' ).replace( '{count}', mediaFileInput.files.length );
                        }
                        else if ( file.name ) {
                            //console.log('case 2');
                            fileName = file.name;
                        }
                        else {
                            //console.log('case 3');
                            //label.html( labelVal );
                        }

                        // display the filename if there is one, otherwise restore the original label
                        if ( fileName ) {
                            //console.log('case 4');
                            //label.find( 'span' ).html( fileName );
                            labelSpan.html( fileName );
                        }
                        else {
                            //console.log('case 5');
                            //label.html( labelVal );
                            labelSpan.html( labelSpanVal );
                        }
                }

            //}

        }
    }, false);

}, { capture: false, once: true });

window.addEventListener('dragover', function(e) {
    e = e || event;
    e.preventDefault();
}, false);

window.addEventListener('drop', function(e) {
    e = e || event;
    e.preventDefault();
}, false);

</script>
