<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// BACK-END FIELD HANDLING
//================================================================================

/**
 * If a post of "post" type was updated,
 * then adjust the "date_updated" custom field.
 */
function news_post_update_modified_date($post_id, $post, $update)
{
    if ( $post->post_type == 'post' && $update ) {
        // If the "date_updated" custom field exists, update it.
        if ( get_field('field_659396c34038c') ) {
            update_field('field_659396c34038c', get_the_modified_time('j F Y, H:i', $post_id), $post_id);
        }
    }
    else if ( $post->post_type == 'post' && !$update ) {
        // If the "date_created" custom field value does not exist, initialiaze it.
        if ( !get_field('field_659396c14038b') ) {
            update_field( 'field_659396c14038b', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );
        }
        // If the "date_updated" custom field value does not exist, initialiaze it.
        if ( !get_field('field_659396c34038c') ) {
            update_field( 'field_659396c34038c', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );
        }
    }
}
add_action('save_post', 'news_post_update_modified_date', 10, 3);

function news_load_applicant_name( $value, $post_id, $field ) {

    $user_id = get_field('news_registered_user_id', $post_id);

    if ( !$user_id ) {
        return $value;
    }

    $user = get_user_by('id', (int) $user_id);

    if ( $value != $user->display_name ) {
        $value = $user->display_name;
    }

    return $value;
}
add_filter('acf/load_value/key=field_659396c84038d', 'news_load_applicant_name', 10, 3); # Applicant's Name

function news_load_applicant_email( $value, $post_id, $field ) {

    $user_id = get_field('news_registered_user_id', $post_id);

    if ( !$user_id ) {
        return $value;
    }

    $user = get_user_by('id', (int) $user_id);

    if ( $value != $user->user_email ) {
        $value = $user->user_email;
    }

    return $value;
}
add_filter('acf/load_value/key=field_659396cc4038e', 'news_load_applicant_email', 10, 3); # Applicant's E-mail

function news_load_applicant_profile_url( $value, $post_id, $field ) {

    if ( function_exists('bp_is_active') ) {

        $user_id = get_field('news_registered_user_id', $post_id);

        if ( !$user_id ) {
            return $value;
        }

        $user_profile_url = bbp_get_user_profile_url( (int) $user_id );

        if ( $value != $user_profile_url ) {
            $value = $user_profile_url;
        }
    }

    return $value;
}
add_filter('acf/load_value/key=field_659396d240390', 'news_load_applicant_profile_url', 10, 3); # Applicant's Profile URL

function news_render_applicant_profile_url( $field ) {
    // echo '<pre>';
    // var_dump($field);
    // echo '</pre>';
    if ( $field['value'] ) {
        echo '<a href="'.$field['value'].'" target="_blank" style="display: inline-block; background-color: aliceblue; padding: 5px; border-radius: 0 0 5px 5px; text-decoration: none;">'.__('Visit profile', 'erua').'</a>';
    }
}
add_action( 'acf/render_field/key=field_659396d240390', 'news_render_applicant_profile_url', 10, 1 );

//================================================================================
// DISABLING STUFF
//================================================================================

/**
 * Make an ACF field readonly to prevent editing.
 * https://www.advancedcustomfields.com/resources/acf-load_field/
 * https://support.advancedcustomfields.com/forums/topic/read-only-field-2/
 */
function news_acf_make_field_readonly( $field ) {

    // $field['choices'] = array(
    //     'custom' => 'My Custom Choice'
    // );
    //$field['disabled'] = 1;
    $field['readonly'] = true;

    return $field;

}
/**
 * Make an ACF field disabled to prevent editing.
 * https://www.advancedcustomfields.com/resources/acf-load_field/
 * https://github.com/AdvancedCustomFields/acf/issues/26
 */
function news_acf_make_field_disabled( $field ) {

    $field['disabled'] = true;

    return $field;

}
add_filter('acf/load_field/key=field_659396c84038d', 'news_acf_make_field_readonly'); # Applicant's Name
add_filter('acf/load_field/key=field_659396cf4038f', 'news_acf_make_field_readonly'); # Applicant's User ID
add_filter('acf/load_field/key=field_659396c14038b', 'news_acf_make_field_readonly'); # Date created
add_filter('acf/load_field/key=field_659396c34038c', 'news_acf_make_field_readonly'); # Date updated
add_filter('acf/load_field/key=field_659396d640391', 'news_acf_make_field_readonly'); # Unique Token
if ( !current_user_can('administrator') ) {
    add_filter('acf/load_field/key=field_659396cc4038e', 'news_acf_make_field_readonly'); # Applicant's E-mail
}

/**
 * Disable various fields at a Post's editing screen.
 */
function erua_disable_post_fields() {
    global $pagenow;

    // If we are at the back-office, at a post.
    if ( is_admin() && !( defined( 'DOING_AJAX' ) && DOING_AJAX ) && ($pagenow == 'post.php' || $pagenow == 'post-new.php') && get_post_type() == 'post' ) {
    ?>
        <script>
        jQuery(document).ready(function() {
            // Disable ACF's date picker at Post's editing screen.
            jQuery('#news-date-created .hasDatepicker').prop('disabled', 'disabled');
            jQuery('#news-date-updated .hasDatepicker').prop('disabled', 'disabled');

            jQuery("div[data-key='field_659396c14038b']").css({position: "relative"});
            jQuery("div[data-key='field_659396c14038b']").prepend('<div id="date-created-tracking-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');
            jQuery("div[data-key='field_659396c34038c']").css({position: "relative"});
            jQuery("div[data-key='field_659396c34038c']").prepend('<div id="date-updated-tracking-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');

            // Hide Status Tracking
            jQuery("div[data-key='field_64684293f7252']").css({position: "relative"});
            jQuery("div[data-key='field_64684293f7252']").prepend('<div id="status-tracking-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');

            // Hide Unique ID
            jQuery("div[data-key='field_659396d640391']").css({position: "relative"});
            jQuery("div[data-key='field_659396d640391']").prepend('<div id="unique-id-jammer" style="display:block; position:absolute; top:0; left:0; width:100%; height:100%; cursor: initial; z-index:9; background-color: aliceblue;"></div>');

        });
        </script>
    <?php
    }

}
add_action('admin_print_footer_scripts', 'erua_disable_post_fields');

//================================================================================
// BUBBLE NOTIFICATIONS
//================================================================================

/**
 * Notification "bubble" with pending/open Posts count
 */
add_action('admin_menu', function () {
    global $menu;
    //$count_posts = wp_count_posts('post');
    //$count = $count_posts->pending;

    // View all Posts with an awaiting nature (pending, waiting for x's reply etc.) of status
    $posts_query = get_posts(
        [
            'post_type' => 'post',
            'fields' => 'ids',
            //'post_status' => 'any', // Published, Pending etc.
            //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash'],
            'post_status' => ['pending', 'draft'],
            'numberposts' => -1,
            // All Posts that are not solved or closed i.e. pending or open
            // 'tax_query' => [
            //     [
            //         'taxonomy' => 'post-status',
            //         'field' => 'slug',
            //         'terms' => ['closed', 'solved'],
            //         'operator' => 'NOT IN',
            //     ],
            // ],
        ]
    );
    if (!empty($posts_query)) wp_reset_postdata();
    $count = count($posts_query);
    /* echo '<pre>';
    var_dump($posts_query);
    echo '</pre>';
    die(); */

    $menu_item = wp_list_filter(
        $menu,
        [2 => 'edit.php'] // 2 is the position of an array item which contains URL, it will always be 2!
    );
    if ( !empty($menu_item) && $count > 0 ) {
        $menu_item_position = key($menu_item); // get the array key (position) of the element
        $menu[$menu_item_position][0] .= ' <span class="awaiting-mod" title="' . $count . ' Posts require actions">' . $count . '</span>';
    }
});
