<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

function news_events_menu_shortcode() {

    $menu = get_field('news_events_menu', 'option');

    if ( $menu && is_array($menu) && !empty($menu) ) {

        $output = '';
        ob_start();
        ?>
        <nav class="erua-navbar">
            <div class="container-fluid">
                <ul class="navbar-nav">
                <?php
                foreach( $menu as $menu_item ) {
                    echo '<li class="nav-item">';

                    $fa_icon_class = ( $menu_item['news_events_menu_top_level_item_fa_icon'] !== '' ) ? $menu_item['news_events_menu_top_level_item_fa_icon'] : '';
                    $fa_icon_html = '<i class="'.esc_attr($fa_icon_class).'"></i>';

                    $title = $menu_item['news_events_menu_top_level_item'];
                    $login_required = $menu_item['news_events_menu_top_level_item_require_login'];
                    $allowed_user_roles = $menu_item['news_events_menu_top_level_item_allowed_user_roles'];

                    // echo '<pre>';
                    // var_dump($allowed_user_roles);
                    // echo '</pre>';

                    $link = ( $menu_item['news_events_menu_top_level_item_is_page'] ) ? $menu_item['news_events_menu_top_level_item_page'] : $menu_item['news_events_menu_top_level_item_link'];
                    $link = ( $link === '' ) ? '#' : $link;

                    $hasSubMenus = ( ! empty($menu_item['news_events_submenu_group']) ) ? true : false;
                    $topMenuItemClass = ( $hasSubMenus ) ? 'dropdown-toggle' : 'nav-item-link';

                    echo '<a class="'.$topMenuItemClass.'" href="'.$link .'">'.$fa_icon_html.'<span>'.esc_html($title).'</span></a>';

                    if ( $hasSubMenus ) {
                        echo '<div class="dropdown-menu">';

                        foreach( $menu_item['news_events_submenu_group'] as $submenu_group_item ) {

                            $heading = ( $submenu_group_item['news_events_submenu_group_heading_choice'] ) ? $submenu_group_item['news_events_submenu_group_heading'] : null;
                            if ( $heading ) echo '<h6 class="dropdown-header">'.esc_html($heading).'</h6>';

                            foreach( $submenu_group_item['news_events_submenu_group_items'] as $submenu_item ) {

                                $icon = ( $submenu_item['news_events_submenu_group_item_icon'] ) ? $submenu_item['news_events_submenu_group_item_icon']['sizes']['thumbnail'] : null;

                                $title = $submenu_item['news_events_submenu_group_item_title'];
                                $subtitle_html = ( $submenu_item['news_events_submenu_group_item_subtitle'] ) ? '<p class="menu-item-subtitle">'.$submenu_item['news_events_submenu_group_item_subtitle'].'</p>' : '';

                                $link = ( $submenu_item['news_events_submenu_group_item_is_page'] ) ? $submenu_item['news_events_submenu_group_item_page'] : $submenu_item['news_events_submenu_group_item_link'];
                                $link = ( $link === '' ) ? '#' : $link;

                                echo '<a class="dropdown-item" href="'.$link.'">';
                                if ( $icon ) echo '<div class="dropdown-item-image"><img class="menu-item-image" src="'.$icon.'" /></div>';
                                echo '<div class="bold"><div><span>'.esc_html($title).'</span></div>'.$subtitle_html.'</div>';
                                echo '</a>';
                            }
                        }

                        echo '</div>';
                    }
                    echo '</li>';
                }
                ?>
                </ul>
            </div>
        </nav>
        <?php
        $output = ob_get_contents();
        ob_end_clean();
    }

    // echo '<pre>';
    // var_dump($menu);
    // echo '</pre>';

    return $output;
}
add_shortcode( 'news_events_menu', 'news_events_menu_shortcode' );