<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// ACF CUSTOM BLOCKS
//================================================================================

/**
 * Start new Hackathon posts with a template.
 * 
 * https://developer.wordpress.org/block-editor/reference-guides/block-api/block-templates/#custom-post-types
 * https://stackoverflow.com/questions/69267185/wordpress-create-new-page-article-with-preloaded-gutenberg-blocks
 */
function hackathon_register_template() {
    $post_type_object = get_post_type_object( 'hackathon' );
    $post_type_object->template = array(
        array('core/heading', array(
            'level' => 2,
            'content' => 'Want to create a new Hackathon?',
        )),
        array( 'core/paragraph', array(
            'content' => 'Click on the plus [+] button at the top left to open the Block Inserter, then choose from Patterns &gt; My patterns &gt; "Hackathon Template". You may also search for "Hackathon Template" (without the quotes) in the Block Inserter. By inserting this prepared template, you can speed up the creation of new Hackathons! Remember to delete all these instructions before publishing!',
        ) ),
        array('core/heading', array(
            'level' => 2,
            'content' => 'Edit the "Hackathon Template"',
        )),
        array( 'core/paragraph', array(
            'content' => 'You may edit the above template to your own preference, in order to use it with all new Hackathons. Simply open Gutenberg\'s -the name of this content editor- Options by clicking on the three vertical dots at the top right of this editor, then select "Manage patterns" from the tools, and open the Hackathon Template for editing. Remember to save your changes! None of your existing Hackathons will be affected by changing this template.',
        ) ),
    );
}
add_action( 'init', 'hackathon_register_template' );

/**
 * ACF Blocks for Gutenberg
 * https://www.billerickson.net/innerblocks-with-acf-blocks/
 * https://www.advancedcustomfields.com/blog/acf-5-8-introducing-acf-blocks-for-gutenberg/
 * https://www.advancedcustomfields.com/blog/acf-5-9-0-release-inner-blocks-ui-improvements-and-exciting-features/#inner-blocks
 */
function hackathon_acf_block_render_callback( $block ) {

    // convert name ("acf/whatever") into path friendly slug ("whatever")
    $slug = str_replace('acf/', '', $block['name']);

    // include a template part from within the "template-parts/block" folder
    if( file_exists( get_theme_file_path("/template-parts/block/content-{$slug}.php") ) ) {
        include( get_theme_file_path("/template-parts/block/content-{$slug}.php") );
    }
}

//================================================================================
// FIELD HANDLING
//================================================================================

/**
 * If a post of "hackathon" type was updated,
 * then transfer some ACF field data to WP post_meta.
 * 
 * https://github.com/pods-framework/pods/issues/3753
 * https://wordpress.stackexchange.com/questions/262864/update-post-meta-not-working-in-save-post
 */
function hackathon_after_save_post( $post_id )
{
    if ( get_post_type($post_id) == 'hackathon' ) {

        $hackathon_date_start = ( get_field('field_65b128d4a058c', $post_id) ) ?? null;
        $hackathon_date_end = ( get_field('field_65b128dfa058d', $post_id) ) ?? null;
        $hackathon_is_featured = ( get_field('field_65b12a7a1220a', $post_id) ) ? 1 : 0;

        // delete_post_meta($post_id, 'hackathon_featured_enabled');
        // delete_post_meta($post_id, 'hackathon_datetime_start');
        // delete_post_meta($post_id, 'hackathon_datetime_end');

        // update_post_meta($post_id, 'hackathon_featured_enabled', $hackathon_is_featured);

        // if ( $hackathon_date_start ) {
        //     update_post_meta($post_id, 'hackathon_datetime_start', $hackathon_date_start);
        // } else {
        //     update_post_meta($post_id, 'hackathon_datetime_start', 0);
        // }

        // if ( $hackathon_date_end ) {
        //     update_post_meta($post_id, 'hackathon_datetime_end', $hackathon_date_end);
        // } else {
        //     update_post_meta($post_id, 'hackathon_datetime_end', 0);
        // }

    }

}
//add_action('acf/save_post', 'hackathon_after_save_post', 20);

/**
 * Make sure that the start date is earlier than the end date.
 *
 * https://support.advancedcustomfields.com/forums/topic/validation-of-a-field-based-on-the-value-of-another-field/
 */
function hackathons_validate_end_date_field( $valid, $value, $field, $input ) {

    // bail early if value is already invalid
    if( !$valid || !isset($_POST['acf']['field_65b128d4a058c']) ) {

        return $valid;

    }

    //$hackathon_start_date = DateTime::createFromFormat('d/m/Y H:i:s', $_POST['acf']['field_65b128d4a058c']);
    //$hackathon_end_date = DateTime::createFromFormat('d/m/Y H:i:s', $value);
    $hackathon_start_date = $_POST['acf']['field_65b128d4a058c'];
    $hackathon_end_date = $value;

    if ( $hackathon_start_date === false || $hackathon_end_date === false ) return $valid;

    if ( $hackathon_end_date < $hackathon_start_date ) {
        $valid = __( "Your end date shouldn't be earlier than the start date.", 'erua' );
    }

    // return
    return $valid;
}
add_filter('acf/validate_value/key=field_65b128dfa058d', 'hackathons_validate_end_date_field', 10, 4);

//================================================================================
// BUBBLE NOTIFICATIONS
//================================================================================

/**
 * Notification "bubble" with pending/open Hackathons count
 */
add_action('admin_menu', function () {
    global $menu;
    //$count_posts = wp_count_posts('hackathon');
    //$count = $count_posts->pending;

    // View all Hackathons with an awaiting nature (pending, waiting for x's reply etc.) of status
    $hackathons_query = get_posts(
        [
            'post_type' => 'hackathon',
            'fields' => 'ids',
            //'post_status' => 'any', // Published, Pending etc.
            //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash'],
            //'post_status' => ['publish', 'pending', 'draft', 'future', 'private', 'inherit'],
            'post_status' => ['pending', 'draft'],
            'numberposts' => -1,
        ]
    );
    if (!empty($hackathons_query)) wp_reset_postdata();
    $count = count($hackathons_query);
    /* echo '<pre>';
    var_dump($hackathons_query);
    echo '</pre>';
    die(); */

    $menu_item = wp_list_filter(
        $menu,
        [2 => 'edit.php?post_type=hackathon'] // 2 is the position of an array item which contains URL, it will always be 2!
    );
    if ( !empty($menu_item) && $count > 0 ) {
        $menu_item_position = key($menu_item); // get the array key (position) of the element
        $menu[$menu_item_position][0] .= ' <span class="awaiting-mod" title="' . $count . ' Hackathons require actions">' . $count . '</span>';
    }
});

