<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Enqueue scripts that change the Job listings data via AJAX.
 */
function erua_enqueue_job_search_script() {

    global $post;
    //global $wp;

    $job_opportunities_page_id = ( get_field('job_opportunities_page', 'option') ) ?? null;

    /**
     * If @ Science and Society - Job Opportunities page
     */
    if ( $post && $job_opportunities_page_id && $job_opportunities_page_id === intval($post->ID) ) {

        // Enqueue the script in the footer!
        wp_enqueue_script('erua-ajax-search-opportunities', get_stylesheet_directory_uri() . '/assets/js/ajax-search-opportunities.js', '', '', true);

        global $wp_query;
        $qvars = $wp_query->query;
        //$qvars['testing'] = 'hmm';
        // Push the query vars to the above script
        wp_localize_script('erua-ajax-search-opportunities', 'ajax_query_data', ['query' => $qvars]);

        $params = [
            '_ajax_url' => admin_url('admin-ajax.php'),
            '_ajax_action' => 'the_jobs_search', # load function hooked to: "wp_ajax_*" action hook
            //'_ajax_post_id' => get_the_ID(),
            /**
             * The nonce is generated based on the current time, 
             * the provided string argument, and the current user ID.
             * https://codex.wordpress.org/Function_Reference/wp_create_nonce
             */
            '_ajax_nonce' => wp_create_nonce('job_filtering_nonce'),
        ];
        // Additionally push some necessary variables to the script
        wp_localize_script('erua-ajax-search-opportunities', 'ajax_object', $params);

    }

}
add_action('wp_enqueue_scripts', 'erua_enqueue_job_search_script', 100);

//================================================================================
// AJAX ACTIONS.
//================================================================================

/**
 * This function filters Job listings via AJAX.
 */
function erua_ajax_search_jobs() {

    /*-------------------------------------------------------------------
        SECURITY
    -------------------------------------------------------------------*/

    /**
     * If the nonce is not set or incorrect, then check_ajax_referrer() 
     * will cause the AJAX call to die, protecting your AJAX call from invalid requests.
     * 
     * https://codex.wordpress.org/WordPress_Nonces
     */
    //check_ajax_referer('job_filtering_nonce', 'ajaxnonce');
    if ( ! check_ajax_referer('job_filtering_nonce', 'ajaxnonce') ) {
        wp_send_json_error();
    }

    // Note: Consider implementing some throttling mechanism to limit AJAX requests?
    // https://stackoverflow.com/questions/7082527/jquery-throttling-and-queuing-of-ajax-requests

    /*-------------------------------------------------------------------
        DEBUG FORM DATA
    -------------------------------------------------------------------*/

    // $html = '';
    // ob_start();

    // echo '<pre>';
    // var_dump($_POST['form_data']);
    // echo '</pre>';

    // $html = ob_get_contents();
    // ob_end_clean();

    // $response = [
    //     'html' => $html,
    // ];
    // wp_send_json_success($response);
    // die();

    /*-------------------------------------------------------------------
        GATHER ALL $_POST DATA
    -------------------------------------------------------------------*/

    $ajax_keyword_search = null;
    $ajax_job_fields = null;
    $ajax_job_provider = null;
    $ajax_job_domains = null;
    $ajax_job_profiles = null;
    $ajax_job_type = null;
    $ajax_job_status = null;
    $ajax_deadline_search = null;

    if ( isset($_POST['form_data']['field_659a47a78b0d1']) ) {
        $ajax_keyword_search = ( strlen($_POST['form_data']['field_659a47a78b0d1'][0]) >=3 ) ? $_POST['form_data']['field_659a47a78b0d1'][0] : null;
    }
    if ( isset($_POST['form_data']['field_65a727b10c89a']) ) {
        $ajax_job_fields = filter_var_array($_POST['form_data']['field_65a727b10c89a'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65a728aa43959']) ) {
        $ajax_job_provider = filter_var_array($_POST['form_data']['field_65a728aa43959'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_659a4caf345ac']) ) {
        $ajax_job_domains = filter_var_array($_POST['form_data']['field_659a4caf345ac'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_659a4d29dd55d']) ) {
        $ajax_job_profiles = filter_var_array($_POST['form_data']['field_659a4d29dd55d'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_659a4d86e99f8']) ) {
        $ajax_job_type = filter_var_array($_POST['form_data']['field_659a4d86e99f8'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_659a4daed2bf1']) ) {
        $ajax_job_status = filter_var_array($_POST['form_data']['field_659a4daed2bf1'], FILTER_VALIDATE_INT);
    }
    if ( isset($_POST['form_data']['field_65bb28958bcd0']) ) {
        // format: Ymd
        $ajax_deadline_search = filter_var_array($_POST['form_data']['field_65bb28958bcd0'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        if ($ajax_deadline_search) $ajax_deadline_search = $ajax_deadline_search[0];
    }

    $ajax_taxonomy = filter_var($_POST['form_data']['_ajax_taxonomy'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_taxonomy_rewrite_slug = filter_var($_POST['form_data']['_ajax_taxonomy_rewrite_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    //$ajax_category = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    //$query_args = filter_input(INPUT_POST, 'query_args', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
    $ajax_original_url = filter_var($_POST['form_data']['_ajax_original_page_url'], FILTER_VALIDATE_URL);
    $ajax_original_term_slug = filter_var($_POST['form_data']['_ajax_original_page_slug'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $ajax_original_term_id = filter_var($_POST['form_data']['_ajax_original_term_id'], FILTER_VALIDATE_INT);

    /*-------------------------------------------------------------------
        PROCESS DATA
    -------------------------------------------------------------------*/

    $job_opportunity_field_ids = [];
    $job_opportunity_provider_ids = [];
    $job_opportunity_domain_ids = [];
    $job_opportunity_profile_ids = [];
    $job_opportunity_type_ids = [];
    $job_opportunity_status_ids = [];

    // Find all available job opportunity field terms
    $all_job_fields = get_terms( [ 'taxonomy' => 'job-opportunity-field', 'hide_empty' => false ] );

    // Find all available job opportunity provider terms
    $all_providers = get_terms( [ 'taxonomy' => 'job-opportunity-provider', 'hide_empty' => false ] );

    // Find all available job opportunity domain terms
    $all_domains = get_terms( [ 'taxonomy' => 'job-opportunity-domain', 'hide_empty' => false ] );

    // Find all available job opportunity profile terms
    $all_profiles = get_terms( [ 'taxonomy' => 'job-opportunity-profile', 'hide_empty' => false ] );

    // Find all available job opportunity type terms
    $all_types = get_terms( [ 'taxonomy' => 'job-opportunity-type', 'hide_empty' => false ] );

    // Find all available job opportunity status terms
    $all_statuses = get_terms( [ 'taxonomy' => 'job-opportunity-status', 'hide_empty' => false ] );

    foreach ( $all_job_fields as $job_field ) {
        array_push($job_opportunity_field_ids, $job_field->term_id);
    }

    foreach ( $all_providers as $provider ) {
        array_push($job_opportunity_provider_ids, $provider->term_id);
    }

    foreach ( $all_domains as $domain ) {
        array_push($job_opportunity_domain_ids, $domain->term_id);
    }

    foreach ( $all_profiles as $profile ) {
        array_push($job_opportunity_profile_ids, $profile->term_id);
    }

    foreach ( $all_types as $type ) {
        array_push($job_opportunity_type_ids, $type->term_id);
    }

    foreach ( $all_statuses as $status ) {
        array_push($job_opportunity_status_ids, $status->term_id);
    }

    // A provided job opportunity field can only be an existing job-opportunity-field taxonomy
    if ( !empty($ajax_job_fields) ) {
        foreach( $ajax_job_fields as $field ) {
            if ( !in_array( (int) $field, $job_opportunity_field_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided job opportunity provider can only be an existing job-opportunity-provider taxonomy
    if ( !empty($ajax_job_provider) ) {
        foreach( $ajax_job_provider as $provider ) {
            if ( !in_array( (int) $provider, $job_opportunity_provider_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided job opportunity domain can only be an existing job-opportunity-domain taxonomy
    if ( !empty($ajax_job_domains) ) {
        foreach( $ajax_job_domains as $domain ) {
            if ( !in_array( (int) $domain, $job_opportunity_domain_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided job opportunity profile can only be an existing job-opportunity-profile taxonomy
    if ( !empty($ajax_job_profiles) ) {
        foreach( $ajax_job_profiles as $profile ) {
            if ( !in_array( (int) $profile, $job_opportunity_profile_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided job opportunity type can only be an existing job-opportunity-type taxonomy
    if ( !empty($ajax_job_type) ) {
        foreach( $ajax_job_type as $type ) {
            if ( !in_array( (int) $type, $job_opportunity_type_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    // A provided job opportunity status can only be an existing job-opportunity-status taxonomy
    if ( !empty($ajax_job_status) ) {
        foreach( $ajax_job_status as $status ) {
            if ( !in_array( (int) $status, $job_opportunity_status_ids ) ) {
                //wp_send_json_error('Type Error');
                die();
            }
        }
    }

    /*-------------------------------------------------------------------
        SET QUERY VARS
    -------------------------------------------------------------------*/

    $filters = [];

    if ( !empty($ajax_job_fields) && $ajax_taxonomy !== 'job-opportunity-field' ) {
        $temp = implode( ',', $ajax_job_fields );
        set_query_var( 'job_fields', $temp );
        $filters['job_fields'] = $temp;
    }
    if ( !empty($ajax_job_provider && $ajax_taxonomy !== 'job-opportunity-provider' ) ) {
        $temp = implode( ',', $ajax_job_provider );
        set_query_var('job_provider', $temp );
        $filters['job_provider'] = $temp;
    }
    if ( !empty($ajax_job_domains && $ajax_taxonomy !== 'job-opportunity-domain' ) ) {
        $temp = implode( ',', $ajax_job_domains );
        set_query_var('job_domains', $temp );
        $filters['job_domains'] = $temp;
    }
    if ( !empty($ajax_job_profiles) && $ajax_taxonomy !== 'job-opportunity-profile' ) {
        $temp = implode( ',', $ajax_job_profiles );
        set_query_var( 'job_profiles', $temp );
        $filters['job_profiles'] = $temp;
    }
    if ( !empty($ajax_job_type && $ajax_taxonomy !== 'job-opportunity-type' ) ) {
        $temp = implode( ',', $ajax_job_type );
        set_query_var('job_type', $temp );
        $filters['job_type'] = $temp;
    }
    if ( !empty($ajax_job_status && $ajax_taxonomy !== 'job-opportunity-status' ) ) {
        $temp = implode( ',', $ajax_job_status );
        set_query_var('job_status', $temp );
        $filters['job_status'] = $temp;
    }
    if ( !empty($ajax_deadline_search) ) {
        set_query_var('deadline', $ajax_deadline_search);
        $filters['deadline'] = $ajax_deadline_search;
    }
    if ( !empty($ajax_keyword_search) && strlen($ajax_keyword_search) >=3 ) {
        set_query_var('keywords', $ajax_keyword_search);
        $filters['keywords'] = $ajax_keyword_search;
    }
    //set_query_var('paged', 0);

    $query_string = http_build_query($filters);
    $query_string = ( empty($query_string) ) ? '?viewing=all' : '?'.$query_string;

    // If there is an AJAX-provided "viewing" filter, select it.
    //$ajax_filter = (!empty($query_args['viewing' ])) ? $query_args['viewing' ] : 'default';

    /*-------------------------------------------------------------------
        HANDLE PAGINATION
    -------------------------------------------------------------------*/

    /**
     * In order for pagination to work, we need to build again the base URL path.
     * The site_url() gets prepended automatically to the base.
     * 
     * Thus, if our base is "something/mypage/",
     * the base will become "https://mydomain/something/mypage/",
     * and pagination path will be appended to that e.g. "https://mydomain/something/mypage/page/x/"
     * 
     * // https://stackoverflow.com/questions/20150653/wordpress-pagination-not-working-with-ajax
     */
    $path = ( empty($ajax_taxonomy) )
    ? $ajax_original_term_slug . '/'
    : $ajax_taxonomy_rewrite_slug . '/' . $ajax_original_term_slug . '/';

    $base = $path . $query_string;

    $original_req_uri = $_SERVER['REQUEST_URI']; # "/wp-admin/admin-ajax.php"

    /**
     * Overwrite the REQUEST_URI variable on which 
     * pagination ("get_pagenum_link()") depends on in order to build its links
     */
    $_SERVER['REQUEST_URI'] = $base;

    /*-------------------------------------------------------------------
        BUILD NEW QUERY & RENDER THE NEW CONTENT
    -------------------------------------------------------------------*/

    /**
     * The security checks have passed 
     * and the user is allowed to run the specified query.
     * Create a new query!
     */
    $new_query_args = getJobOpportunityQueryArguments($ajax_job_domains, $ajax_job_fields, $ajax_job_profiles, $ajax_job_provider, $ajax_job_status, $ajax_job_type, null, $ajax_deadline_search, $ajax_keyword_search);

    // Will reset previous WP Query and clear all query vars!
    wp_reset_query();
    $wp_query = new WP_Query($new_query_args);

    $job_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
    $job_taxonomies['job-opportunity-domain'] = get_taxonomy('job-opportunity-domain');
    $job_taxonomies['job-opportunity-field'] = get_taxonomy('job-opportunity-field');
    $job_taxonomies['job-opportunity-profile'] = get_taxonomy('job-opportunity-profile');
    $job_taxonomies['job-opportunity-provider'] = get_taxonomy('job-opportunity-provider');
    $job_taxonomies['job-opportunity-status'] = get_taxonomy('job-opportunity-status');
    $job_taxonomies['job-opportunity-type'] = get_taxonomy('job-opportunity-type');

    $html = '';
    ob_start();

    include_once __DIR__ . '/listings-content.php';

    // echo '<pre>';
    // var_dump($new_query_args);
    // echo '</pre>';

    $html = ob_get_contents();
    ob_end_clean();

    // Restore the original REQUEST_URI - in case anything else would resort on it
    $_SERVER['REQUEST_URI'] = $original_req_uri;

    /*-------------------------------------------------------------------
        SEND RESPONSE
    -------------------------------------------------------------------*/
    $response = [
        'html' => $html,
        'query_string' => $query_string,
        'wp_query_args' => $new_query_args,
        'base_url' => $path,
        'results' => $wp_query->post_count
    ];
    wp_send_json_success($response);
    die(); // required. to end AJAX request.
}
// handling ajax action for logged-in users and guests
add_action('wp_ajax_the_jobs_search', 'erua_ajax_search_jobs');
add_action('wp_ajax_nopriv_the_jobs_search', 'erua_ajax_search_jobs');
