<?php if ( $wp_query->have_posts() ) : ?>

<h2 id="results-title">
    <span style="display: inline-block;" title="<?php printf( _n( 'Showing %s job opportunity of %s job opportunities', 'Showing %s of %s job opportunities', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>"><?php printf( _n( 'There is %s job opportunity', 'There are %s job opportunities', $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->found_posts ) ); ?></span>
</h2>

<ul class="jobs-list">
<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
    <?php //do_action( 'flatsome_before_page_content' ); ?>

        <?php
        $job_opportunity_field_terms = get_the_terms( get_the_ID(), $job_taxonomies['job-opportunity-field']->name );
        $job_opportunities_page_id = ( get_field('job_opportunities_page', 'option') ) ?? null;

        // How can i put "posted x minutes ago on my posts?
        // https://wordpress.stackexchange.com/questions/36184/how-can-i-put-posted-x-minutes-ago-on-my-posts
        ?>

        <li class="job">
            <!-- <?php //if ( has_post_thumbnail() ) : ?>
            <div class="job-image">
                <a class="job-link" href="<?php //echo get_permalink(); ?>" title="<?php //echo esc_attr(get_the_title()); ?>"><?php //the_post_thumbnail('medium') ?></a>
            </div>
            <?php //endif; ?> -->
            <div class="job-info">
                <div class="job-info-inner">
                    <h2 class="job-title"><a class="job-link two-line-box" href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
                        <span class="job-text"><?php echo get_the_title(); ?></span>
                    </a></h2>
                    <div class="job-fields">
                    <?php
                    if ( is_array($job_opportunity_field_terms) ) {
                        foreach ( $job_opportunity_field_terms as $key => $job_field ) {
                            //$separator = ( $key === array_key_last($job_opportunity_field_terms) ) ? '' : ', ';
    
                            //echo '<a class="button primary is-smaller lowercase" href="' . site_url('/') . $job_taxonomies['job-opportunity-field']->rewrite['slug'] . '/' . $job_field->slug . '"> <span>'. $job_field->name .'</span> </a>';
                            if ( $job_opportunities_page_id ) {
                                echo '<a class="button primary is-smaller lowercase" href="' . get_permalink($job_opportunities_page_id) . '?job_fields='.$job_field->term_id.'"> <span>'. $job_field->name .'</span> </a>';
                            }
                            else {
                                echo '<a class="button primary is-smaller lowercase"> <span>'. $job_field->name .'</span> </a>';
                            }
                        }
                    }
                    ?>
                </div>
                </div>
            </div>
            <div class="job-date-status">
                <div class="job-dates">
                    <div class="job-posted-date">
                        <span class="posted-date-title"><?php echo __('Date posted', 'erua'); ?></span>
                        <span class="posted-date-formatted"><strong><?php echo get_the_date( 'd/m/Y' ); ?></strong></span>
                    </div>
                    <div class="job-deadline-date">
                        <span class="deadline-date-title"><?php echo __('Deadline', 'erua'); ?></span>
                        <span class="deadline-date-formatted"><strong><?php echo get_field('job_opportunity_deadline'); ?></strong></span>
                    </div>
                </div>
                <?php
                $job_status = get_field('job_opportunity_status');
                if ( $job_status ) {
                    $job_status_name = $job_status->name;
                    switch($job_status->term_id) {
                        case 209 : # Open
                            $job_status_class = 'success';
                            break;
                        case 210 : # Closed
                            $job_status_class = 'alert';
                            break;
                        case 211 : # Forthcoming
                            $job_status_class = 'primary';
                            break;
                    }
                }
                else {
                    $job_status_name = __('Unknown', 'erua');
                    $job_status_class = 'unknown';
                }
                ?>
                <div class="job-status">
                <?php if ( $job_opportunities_page_id ) : ?>
                    <a class="button <?php echo $job_status_class; ?> expand" href="<?php echo get_permalink($job_opportunities_page_id) . '?job_status='.$job_status->term_id; ?>"><span><?php echo __('Status:', 'erua') . ' ' . $job_status_name; ?></span></a>
                    <?php else : ?>
                    <a class="button <?php echo $job_status_class; ?> expand"><span><?php echo __('Status:', 'erua') . ' ' . $job_status_name; ?></span></a>
                    <?php endif; ?>
                    <span class="job-date"><?php echo __('Last updated on: ', 'erua') . get_the_modified_date( 'd/m/Y' ); ?></span>
                </div>
            </div>
        </li>

    <?php //do_action( 'flatsome_after_page_content' ); ?>
<?php endwhile; // end of the loop. ?>
</ul>

<div id="jobs-pagination" class="pagination jobs-pagination">
<?php
$big = 99999999999; // an unlikely big integer
// https://wordpress.stackexchange.com/questions/303297/paginate-link-generate-additional-038-whenever-my-url-have-multiple-query-stri
echo paginate_links( [
    //'base'            => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
    'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
    //'base'            => str_replace( $big, '%#%', get_pagenum_link( $big, false ) ),
    'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
    'current'         => max( 1, $wp_query->query_vars['paged'] ),
    'total'           => $wp_query->max_num_pages,
    'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
    'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
] );
?>
</div>

<?php
else :
echo '<p style="text-align: center; font-size: 2em; margin-top: 50px;">' . __('No job opportunities found.', 'erua') . '</p>';
endif;

// Restore original post data.
wp_reset_postdata();
