<?php
get_header();
?>

<?php require_once __DIR__ . '/includes/aeiforia/module-top-section.php'; ?>

<div id="content" class="blog-wrapper blog-single page-wrapper">

    <?php
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-9 col">
        <?php
        if( is_single() ) {
            if ( have_posts() ) {

                /* Start the Loop */
                while ( have_posts() ) : the_post();
        ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                        <header class="entry-header">
                            <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                <h6 class="entry-category is-xsmall">
                                    <?php echo get_the_category_list( __( ', ', 'flatsome' ) ) ?>
                                </h6>

                                <?php
                                if ( is_single() ) {
                                    echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                                } else {
                                    echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                                }

                                if ( $project_acronym = get_field('aeiforia_project_acronym') ) {
                                    echo '<p id="project-acronym" class="text-center">' . $project_acronym . '</p>';
                                }

                                if ( is_single() ) {
                                    if ( current_user_can('administrator') ) echo '<a class="post-edit-link" href="' . get_edit_post_link(get_the_ID()) . '">' . __('(Edit project)', 'erua') . '</a>';
                                }
                                ?>

                                <div class="entry-divider is-divider small"></div>

                                <?php
                                $single_aeiforia_project = is_singular( 'aeiforia-project' );
                                if ( $single_aeiforia_project && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php elseif ( ! $single_aeiforia_project && 'aeiforia-project' == get_post_type() ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php //if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                    <div class="entry-image relative">
                                        <?php //get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                        <a href="<?php the_permalink();?>" style="display: flex; justify-content: center; margin-bottom: 20px; ">
                                            <?php the_post_thumbnail('large'); ?>
                                        </a>
                                        <?php //if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                    </div>
                                <?php //endif; ?>
                            <?php endif; ?>
                        </header>
                        <div>
                            <?php
                            $aeiforia_sustainability_pillar_taxonomy = get_taxonomy('aeiforia-sustainability-pillar');
                            $aeiforia_erua_university_taxonomy = get_taxonomy('aeiforia-erua-university');
                            $aeiforia_erua_region_taxonomy = get_taxonomy('aeiforia-erua-region');
                            $aeiforia_erua_stakeholder_taxonomy = get_taxonomy('aeiforia-erua-stakeholder');
                            //$aeiforia_project_status_taxonomy = get_taxonomy('aeiforia-project-status');
                            $aeiforia_project_keyword_tags = get_taxonomy('aeiforia-project-keyword');
                            $aeiforia_science_field_tags = get_taxonomy('aeiforia-science-field');

                            $project_slider_media = get_field('aeiforia_project_slider_media', get_the_ID());

                            $project_category = get_the_terms( get_the_ID(), 'aeiforia-project-category' );
                            $project_regions = null;
                            $project_stakeholders = null;
                            $universities = null;
                            // If in ERUA Regions
                            if ( $project_category && $project_category[0]->term_id === 23 ) {
                                $project_regions = get_the_terms( get_the_ID(), 'aeiforia-erua-region' );
                                $project_stakeholders = get_the_terms( get_the_ID(), 'aeiforia-erua-stakeholder' );
                            }
                            // If in ERUA Alliance
                            else if ( $project_category && $project_category[0]->term_id === 22 ) {
                                $universities = get_the_terms( get_the_ID(), 'aeiforia-erua-university' );
                            }
                            // If in ERUA Students & Citizens
                            else if ( $project_category && $project_category[0]->term_id === 29 ) {
                                $project_regions = get_the_terms( get_the_ID(), 'aeiforia-erua-region' );
                                $universities = get_the_terms( get_the_ID(), 'aeiforia-erua-university' );
                            }

                            $project_students = get_field('aeiforia_project_students', get_the_ID());
                            $sdgs = get_the_terms(get_the_ID(), 'aeiforia-sdg');
                            $pillars = get_the_terms( get_the_ID(), 'aeiforia-sustainability-pillar' );
                            $website_url = get_field('aeiforia_project_website', get_the_ID());
                            $status = get_the_terms(get_the_ID(), 'aeiforia-project-status');
                            $project_significance = ( $status[0]->slug === 'closed' && $project_significance = get_field('aeiforia_project_significance', get_the_ID()) ) ? $project_significance : null;
                            $project_results = ( $status[0]->slug === 'closed' && $project_results = get_field('aeiforia_project_results', get_the_ID()) ) ? $project_results : null;
                            $funding_source = get_the_terms(get_the_ID(), 'aeiforia-funding-source');
                            $funding_programme = get_field('aeiforia_project_funding_programme', get_the_ID());
                            $role = get_field('aeiforia_project_role', get_the_ID());
                            $consortium = get_field('aeiforia_project_consortium', get_the_ID());
                            $countries = get_field('aeiforia_project_countries', get_the_ID());
                            $topic = get_field('aeiforia_project_topic', get_the_ID());
                            $keywords = get_the_terms( get_the_ID(), 'aeiforia-project-keyword' );
                            $science_fields = get_the_terms( get_the_ID(), 'aeiforia-science-field' );
                            ?>
                            <?php if ( $project_slider_media ) : ?>

                            <?php
                            // echo '<pre>';
                            // var_dump($project_slider_media);
                            // echo '</pre>';
                            ?>
                            <div class="swiper-outer-container container">
                                <div class="swiper-container media">
                                    <div class="swiper-wrapper">
                                    <?php
                                    foreach ( $project_slider_media as $media_item ) {
                                        if ( $media_item['aeiforia_project_slider_media_file_location'] === 'Local' && $media_item['aeiforia_project_slider_media_file']['type'] === 'image' ) {
                                            echo '<div class="swiper-slide">';
                                            echo '<img width="600" height="400" src="'.$media_item['aeiforia_project_slider_media_file']['sizes']['medium'].'" data-src="'.$media_item['aeiforia_project_slider_media_file']['sizes']['medium'].'" class="attachment-medium size-medium wp-post-image lazy-load-active" alt="" decoding="async" sizes="(max-width: 600px) 100vw, 600px">';
                                            echo '</div>';
                                        }
                                        else if ( $media_item['aeiforia_project_slider_media_file_location'] === 'Local' && $media_item['aeiforia_project_slider_media_file']['type'] === 'video' ) {
                                            echo '<div class="swiper-slide">';
                                            $video_id = $media_item['aeiforia_project_slider_media_file']['ID'];
                                            $video_url = $media_item['aeiforia_project_slider_media_file']['url'];
                                            echo do_shortcode( "[get_video_block fileid='{$video_id}' url='{$video_url}']" );  
                                            echo '</div>';
                                        }
                                        else if ( $media_item['aeiforia_project_slider_media_file_location'] === 'Remote' && $media_item['aeiforia_project_slider_media_file_type'] === 'Image' ) {
                                            echo '<div class="swiper-slide">';
                                            echo '<img width="600" height="400" src="'.$media_item['aeiforia_project_slider_media_file_image_url'].'" data-src="'.$media_item['aeiforia_project_slider_media_file_image_url'].'" class="attachment-medium size-medium wp-post-image lazy-load-active" alt="" decoding="async" sizes="(max-width: 600px) 100vw, 600px">';
                                            echo '</div>';
                                        }
                                        else if ( $media_item['aeiforia_project_slider_media_file_location'] === 'Remote' && $media_item['aeiforia_project_slider_media_file_type'] === 'Video' ) {
                                            echo '<div class="swiper-slide">';
                                            $video_url = $media_item['aeiforia_project_slider_media_file_video_url'];
                                            $video_url_parts = parse_url( $video_url );
                                            $video_domain = $video_url_parts['host'];
                                            $is_supported_video_provider = preg_match('[youtube\.com|youtu\.be|vimeo\.com|dailymotion\.com]', $video_domain);

                                            if ( $is_supported_video_provider ) {
                                                echo do_shortcode( "[get_video_embed_block url='{$video_url}']" );
                                            }
                                            else {
                                                echo 'Video is not hosted on a supported provider.';
                                            }
                                            echo '</div>';
                                        }
                                        else {
                                            echo '<div class="swiper-slide">';
                                            echo 'Could not render image or video.';
                                            echo '</div>';
                                        }
                                    }
                                    ?>
                                    </div>
                                </div>
                                <!-- Pagination -->
                                <div class="swiper-pagination media"></div>
                                <!-- Navigation -->
                                <div class="swiper-button-next swiper-button-white media"></div>
                                <div class="swiper-button-prev swiper-button-white media"></div>
                            </div>
                            <?php endif; ?>
                            <div class="accordion alternate-style no-counter table-of-contents">
                                <div id="accordion-ps" class="accordion-item">
                                    <a id="accordion-ps-label" class="accordion-title plain plain" href="#accordion-item-project_sections" aria-expanded="false" aria-controls="accordion-ps-content"> <button class="toggle" aria-label="Toggle"><i class="icon-angle-down"></i></button> <span><?php _e('PROJECT SECTIONS', 'erua'); ?></span> </a>
                                    <div id="accordion-ps-content" class="accordion-inner" style="display: none;" aria-labelledby="accordion-ps-label">

                                        <ul>
                                            <?php if ($project_category && $project_category[0]->term_id === 29 && $project_students) : ?>
                                            <li><a href="#project-students" class="toc-link"><?php _e('Student/s - Citizenship', 'erua') ?></a></li>
                                            <?php endif; ?>
                                            <?php if ($sdgs) : ?>
                                            <li><a href="#project-SDGs" class="toc-link"><?php _e('Contribution to the Sustainable Development Goals (SDGs)', 'erua') ?></a></li>
                                            <?php endif; ?>
                                            <?php if ($sdgs) : ?>
                                            <li><a href="#project-pillars" class="toc-link"><?php _e('Sustainability Pillars', 'erua') ?></a></li>
                                            <?php endif; ?>
                                            <li><a href="#project-description" class="toc-link">Description</a></li>
                                            <?php if ($website_url) : ?>
                                            <li><a href="#project-url" class="toc-link">Webpage</a></li>
                                            <?php endif; ?>
                                            <?php if ($status) : ?>
                                            <li><a href="#project-status" class="toc-link">Status (Duration)</a></li>
                                            <?php endif; ?>
                                            <?php if ($project_significance) : ?>
                                            <li><a href="#project-significance" class="toc-link">Socio-economic significance</a></li>
                                            <?php endif; ?>
                                            <?php if ($project_results) : ?>
                                            <li><a href="#project-results" class="toc-link">Results</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_source) : ?>
                                            <li><a href="#project-funding" class="toc-link">Funding Source</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_programme) : ?>
                                            <li><a href="#project-funding-programme" class="toc-link">Funding Programme</a></li>
                                            <?php endif; ?>
                                            <?php if ($universities) : ?>
                                            <li><a href="#project-universities" class="toc-link">ERUA University/ies</a></li>
                                            <?php endif; ?>
                                            <?php if ($project_regions) : ?>
                                            <li><a href="#project-regions" class="toc-link">ERUA Regions</a></li>
                                            <?php endif; ?>
                                            <?php if ($project_stakeholders) : ?>
                                            <li><a href="#project-stakeholders" class="toc-link">ERUA Stakeholders</a></li>
                                            <?php endif; ?>
                                            <?php if ($role) : ?>
                                            <li><a href="#project-role" class="toc-link">Role</a></li>
                                            <?php endif; ?>
                                            <?php if ($topic) : ?>
                                            <li><a href="#project-topic" class="toc-link">Topic</a></li>
                                            <?php endif; ?>
                                            <?php if ($countries) : ?>
                                            <li><a href="#project-countries" class="toc-link">Countries</a></li>
                                            <?php endif; ?>
                                            <?php if ($consortium) : ?>
                                            <li><a href="#project-consortium" class="toc-link">Consortium</a></li>
                                            <?php endif; ?>
                                            <?php if ($keywords) : ?>
                                            <li><a href="#project-keywords" class="toc-link">Keywords</a></li>
                                            <?php endif; ?>
                                            <?php if ($science_fields) : ?>
                                            <li><a href="#project-science-fields" class="toc-link">Fields of science</a></li>
                                            <?php endif; ?>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                            <?php
                            if ($project_category && $project_category[0]->term_id === 29 && $project_students) {
                                echo '<h2 id="project-students">' . __('Student/s - Citizenship', 'erua') . '</h2>';
                                echo '<p>' . $project_students . '</p>';
                            }
                            if ( $sdgs ) {
                                echo '<h2 id="project-SDGs">' . __('Contribution to the Sustainable Development Goals (SDGs)', 'erua') . '</h2>';
                                if ( is_array($sdgs) ) {
                                    foreach($sdgs as $key => $sdg) {
                                        //$separator = ( $key === array_key_last($sdgs) ) ? '' : ', ';
    
                                        if ( $sdg_image = get_field('aeiforia_sdg_image', 'aeiforia-sdg_' . $sdg->term_id) ) {
                                            // echo '<pre>';
                                            // var_dump($sdg_image);
                                            // echo '</pre>';
                                            echo '<img class="" src="'.$sdg_image["sizes"]["thumbnail"].'" style="width: 100px; height: 100px;" />';
                                        }
                                    }
                                }
                            }
                            if ( $pillars ) {
                                echo '<pillars id="project-pillars" style="display: block; margin: 20px 0 0 0;">';
                                if ( is_array($pillars) ) {
                                    foreach ( $pillars as $key => $pillar ) {
                                        $separator = ( $key === array_key_last($pillars) ) ? '' : ', ';
                                
                                        echo '<span class="project-pillar"><a href="' . site_url('/') . $aeiforia_sustainability_pillar_taxonomy->rewrite['slug'] . '/' . $pillar->slug . '">'. $pillar->name .'</a>' . $separator . '</span>' ;
                                    }
                                }
                                echo '</pillars>';
                            }
                            
                            ?>
                        </div>
                        <!-- <aside style="padding: 15px; margin-bottom: 30px; border: 1px solid #999;"> -->
                            <?php                            
                            //echo '<div><strong>Year</strong>: ' . get_the_date( 'Y' ) . '</div>';
                            ?>
                        <!-- </aside> -->
                        <?php get_template_part( 'template-parts/single', 'aeiforia-project' ); ?>
                    </div>
                </article>
        <?php
                endwhile;
            } else {
                get_template_part( 'no-results', 'index' );
            }
            //comments_template();
        }
        ?>
        </div>
        <div class="post-sidebar large-3 col">
            <?php flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php flatsome_sidebar_classes(); ?>" role="complementary">
                <?php do_action( 'before_sidebar' ); ?>
                <?php if ( ! dynamic_sidebar( 'aeiforia-sidebar' ) ) : ?>
                <?php endif; // end sidebar widget area ?>
            </div>
            <?php flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div>
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
