<?php
get_header();
?>

<?php require_once __DIR__ . '/includes/eruahaus/module-top-section.php'; ?>

<div id="content" class="blog-wrapper blog-single page-wrapper">

    <?php
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-9 col">
        <?php
        if( is_single() ) {
            if ( have_posts() ) {

                /* Start the Loop */
                while ( have_posts() ) : the_post();
        ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                        <header class="entry-header">
                            <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                <h6 class="entry-category is-xsmall">
                                    <?php echo get_the_category_list( __( ', ', 'flatsome' ) ) ?>
                                </h6>

                                <?php
                                $current_user_id = get_current_user_id();
                                $project_creator_id = (int) get_field('eruahaus_project_registered_user_id', get_the_ID());
                                $project_group_url = null;

                                if ( function_exists('bp_is_active') ) {
                                    $group_id = get_field('eruahaus_project_group_id', get_the_ID());

                                    if ( $group_id ) {
                                        $group_obj = groups_get_group( (int) $group_id );
                                        $project_group_url = bp_get_group_permalink( $group_obj );
                                    }
                                }

                                if ( is_single() ) {
                                    echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                                } else {
                                    echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                                }

                                if ( $project_acronym = get_field('eruahaus_project_acronym') ) {
                                    echo '<p id="project-acronym" class="text-center">' . $project_acronym . '</p>';
                                }

                                if ( is_single() ) {
                                    if ( current_user_can('administrator') || $current_user_id === $project_creator_id ) echo '<a class="post-edit-link" href="' . get_edit_post_link(get_the_ID()) . '">' . __('(Edit project)', 'erua') . '</a>';

                                    if ( $current_user_id === $project_creator_id && $project_group_url ) {
                                        echo '<a href="' . $project_group_url . 'admin/" class="group-view-button">' . __('Manage your Team Space', 'erua') . '</a>';
                                    }
                                    else if ( $project_group_url ) {
                                        echo '<a href="' . $project_group_url . '" class="group-view-button">' . __('Join the Team', 'erua') . '</a>';
                                    }
                                }
                                ?>

                                <div class="entry-divider is-divider small"></div>

                                <?php
                                $single_eruahaus_project = is_singular( 'eruahaus-project' );
                                if ( $single_eruahaus_project && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php elseif ( ! $single_eruahaus_project && 'eruahaus-project' == get_post_type() ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php //if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                    <div class="entry-image relative">
                                        <?php //get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                        <a href="<?php the_permalink();?>" style="display: flex; justify-content: center; margin-bottom: 20px; ">
                                            <?php the_post_thumbnail('large'); ?>
                                        </a>
                                        <?php //if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                    </div>
                                <?php //endif; ?>
                            <?php endif; ?>
                        </header>
                        <div>
                            <?php
                            $eruahaus_project_focus_area_taxonomy = get_taxonomy('eruahaus-project-focus-area');
                            //$eruahaus_sustainability_pillar_taxonomy = get_taxonomy('eruahaus-sustainability-pillar');
                            $eruahaus_erua_university_taxonomy = get_taxonomy('eruahaus-erua-university');
                            //$eruahaus_project_status_taxonomy = get_taxonomy('eruahaus-project-status');
                            $eruahaus_project_keyword_tags = get_taxonomy('eruahaus-project-keyword');
                            $eruahaus_science_field_tags = get_taxonomy('eruahaus-science-field');

                            $project_slider_media = get_field('eruahaus_project_slider_media', get_the_ID());

                            $sdgs = get_the_terms(get_the_ID(), 'eruahaus-sdg');
                            $focus_areas = get_the_terms( get_the_ID(), 'eruahaus-project-focus-area' );
                            $website_url = get_field('eruahaus_project_website', get_the_ID());
                            $status = get_the_terms(get_the_ID(), 'eruahaus-project-status');
                            //$project_significance = ( $status[0]->slug === 'closed' && $project_significance = get_field('eruahaus_project_significance', get_the_ID()) ) ? $project_significance : null;
                            $project_results = ( $status[0]->slug === 'closed' && $project_results = get_field('eruahaus_project_results', get_the_ID()) ) ? $project_results : null;
                            $funding_source = get_the_terms(get_the_ID(), 'eruahaus-funding-source');
                            $project_initiative = get_field('eruahaus_project_initiative', get_the_ID());
                            $students = get_field('eruahaus_project_students', get_the_ID());
                            $universities = get_the_terms( get_the_ID(), 'eruahaus-erua-university' );
                            //$role = get_field('eruahaus_project_role', get_the_ID());
                            //$consortium = get_field('eruahaus_project_consortium', get_the_ID());
                            //$countries = get_field('eruahaus_project_countries', get_the_ID());
                            $regions = get_field('eruahaus_project_regions', get_the_ID());
                            $stakeholders = get_field('eruahaus_project_stakeholders', get_the_ID());
                            $team = get_field('eruahaus_project_team', get_the_ID());
                            $activities = get_field('eruahaus_project_activities', get_the_ID());
                            $topics = get_field('eruahaus_project_topics', get_the_ID());
                            $coordinator = get_field('eruahaus_project_coordinator', get_the_ID());
                            $contact_person = get_field('eruahaus_project_contact_person', get_the_ID());
                            $keywords = get_the_terms( get_the_ID(), 'eruahaus-project-keyword' );
                            $science_fields = get_the_terms( get_the_ID(), 'eruahaus-science-field' );
                            ?>
                            <?php if ( $project_slider_media ) : ?>

                            <?php
                            // echo '<pre>';
                            // var_dump($project_slider_media);
                            // echo '</pre>';
                            ?>
                            <div class="swiper-outer-container container">
                                <div class="swiper-container media">
                                    <div class="swiper-wrapper">
                                    <?php
                                    foreach ( $project_slider_media as $media_item ) {
                                        if ( $media_item['eruahaus_project_slider_media_file_location'] === 'Local' && $media_item['eruahaus_project_slider_media_file']['type'] === 'image' ) {
                                            echo '<div class="swiper-slide">';
                                            echo '<img width="600" height="400" src="'.$media_item['eruahaus_project_slider_media_file']['sizes']['medium'].'" data-src="'.$media_item['eruahaus_project_slider_media_file']['sizes']['medium'].'" class="attachment-medium size-medium wp-post-image lazy-load-active" alt="" decoding="async" sizes="(max-width: 600px) 100vw, 600px">';
                                            echo '</div>';
                                        }
                                        else if ( $media_item['eruahaus_project_slider_media_file_location'] === 'Local' && $media_item['eruahaus_project_slider_media_file']['type'] === 'video' ) {
                                            echo '<div class="swiper-slide">';
                                            $video_id = $media_item['eruahaus_project_slider_media_file']['ID'];
                                            $video_url = $media_item['eruahaus_project_slider_media_file']['url'];
                                            echo do_shortcode( "[get_video_block fileid='{$video_id}' url='{$video_url}']" );  
                                            echo '</div>';
                                        }
                                        else if ( $media_item['eruahaus_project_slider_media_file_location'] === 'Remote' && $media_item['eruahaus_project_slider_media_file_type'] === 'Image' ) {
                                            echo '<div class="swiper-slide">';
                                            echo '<img width="600" height="400" src="'.$media_item['eruahaus_project_slider_media_file_image_url'].'" data-src="'.$media_item['eruahaus_project_slider_media_file_image_url'].'" class="attachment-medium size-medium wp-post-image lazy-load-active" alt="" decoding="async" sizes="(max-width: 600px) 100vw, 600px">';
                                            echo '</div>';
                                        }
                                        else if ( $media_item['eruahaus_project_slider_media_file_location'] === 'Remote' && $media_item['eruahaus_project_slider_media_file_type'] === 'Video' ) {
                                            echo '<div class="swiper-slide">';
                                            $video_url = $media_item['eruahaus_project_slider_media_file_video_url'];
                                            $video_url_parts = parse_url( $video_url );
                                            $video_domain = $video_url_parts['host'];
                                            $is_supported_video_provider = preg_match('[youtube\.com|youtu\.be|vimeo\.com|dailymotion\.com]', $video_domain);

                                            if ( $is_supported_video_provider ) {
                                                echo do_shortcode( "[get_video_embed_block url='{$video_url}']" );
                                            }
                                            else {
                                                echo 'Video is not hosted on a supported provider.';
                                            }
                                            echo '</div>';
                                        }
                                        else {
                                            echo '<div class="swiper-slide">';
                                            echo 'Could not render image or video.';
                                            echo '</div>';
                                        }
                                    }
                                    ?>
                                    </div>
                                </div>
                                <!-- Pagination -->
                                <div class="swiper-pagination media"></div>
                                <!-- Navigation -->
                                <div class="swiper-button-next swiper-button-white media"></div>
                                <div class="swiper-button-prev swiper-button-white media"></div>
                            </div>
                            <?php endif; ?>
                            <div class="accordion alternate-style no-counter table-of-contents">
                                <div id="accordion-ps" class="accordion-item">
                                    <a id="accordion-ps-label" class="accordion-title plain plain" href="#accordion-item-project_sections" aria-expanded="false" aria-controls="accordion-ps-content"> <button class="toggle" aria-label="Toggle"><i class="icon-angle-down"></i></button> <span><?php _e('PROJECT SECTIONS', 'erua'); ?></span> </a>
                                    <div id="accordion-ps-content" class="accordion-inner" style="display: none;" aria-labelledby="accordion-ps-label">

                                        <ul>
                                            <!-- <li><a href="#project-Title" class="toc-link">Title</a></li>
                                            <li><a href="#project-Acronym" class="toc-link">Acronym</a></li> -->
                                            <?php if ($sdgs) : ?>
                                            <li><a href="#project-SDGs" class="toc-link"><?php _e('Contribution to the Sustainable Development Goals (SDGs)', 'erua') ?></a></li>
                                            <?php endif; ?>
                                            <?php if ($focus_areas) : ?>
                                            <li><a href="#project-focus-areas" class="toc-link"><?php _e('Focus Areas', 'erua') ?></a></li>
                                            <?php endif; ?>
                                            <li><a href="#project-description" class="toc-link">Description</a></li>
                                            <?php if ($website_url) : ?>
                                            <li><a href="#project-url" class="toc-link">Webpage</a></li>
                                            <?php endif; ?>
                                            <?php if ($status) : ?>
                                            <li><a href="#project-status" class="toc-link">Status (Duration)</a></li>
                                            <?php endif; ?>
                                            <?php if ($project_results) : ?>
                                            <li><a href="#project-results" class="toc-link">Results</a></li>
                                            <?php endif; ?>
                                            <?php if ($funding_source) : ?>
                                            <li><a href="#project-funding" class="toc-link">Funding Source</a></li>
                                            <?php endif; ?>
                                            <?php if ($project_initiative) : ?>
                                            <li><a href="#project-initiative" class="toc-link">ERUA Initiative</a></li>
                                            <?php endif; ?>
                                            <?php if ($students) : ?>
                                            <li><a href="#project-students" class="toc-link">ERUA Students</a></li>
                                            <?php endif; ?>
                                            <?php if ($universities) : ?>
                                            <li><a href="#project-universities" class="toc-link">ERUA University/ies</a></li>
                                            <?php endif; ?>
                                            <?php if ($regions) : ?>
                                            <li><a href="#project-regions" class="toc-link">ERUA Region/s</a></li>
                                            <?php endif; ?>
                                            <?php if ($stakeholders) : ?>
                                            <li><a href="#project-stakeholders" class="toc-link">ERUA Stakeholders</a></li>
                                            <?php endif; ?>
                                            <?php if ($team) : ?>
                                            <li><a href="#project-team" class="toc-link">Team</a></li>
                                            <?php endif; ?>
                                            <?php if ($activities) : ?>
                                            <li><a href="#project-activities" class="toc-link">Activities</a></li>
                                            <?php endif; ?>
                                            <?php if ($topics) : ?>
                                            <li><a href="#project-topics" class="toc-link">Topics</a></li>
                                            <?php endif; ?>
                                            <?php if ($coordinator) : ?>
                                            <li><a href="#project-coordinator" class="toc-link">Coordinator</a></li>
                                            <?php endif; ?>
                                            <?php if ($contact_person) : ?>
                                            <li><a href="#project-contact-person" class="toc-link">Contact person</a></li>
                                            <?php endif; ?>
                                            <?php if ($keywords) : ?>
                                            <li><a href="#project-keywords" class="toc-link">Keywords</a></li>
                                            <?php endif; ?>
                                            <?php if ($science_fields) : ?>
                                            <li><a href="#project-science-fields" class="toc-link">Fields of science</a></li>
                                            <?php endif; ?>
                                            <!-- <li><a href="#proj-Tagline" class="toc-link">Tagline</a></li> -->
                                        </ul>

                                    </div>
                                </div>
                            </div>
                            <?php
                            if ( $sdgs ) {
                                echo '<h2 id="project-SDGs">' .__('Contribution to the Sustainable Development Goals (SDGs)', 'erua') . '</h2>';
                                if ( is_array($sdgs) ) {
                                    foreach($sdgs as $key => $sdg) {
                                        //$separator = ( $key === array_key_last($sdgs) ) ? '' : ', ';
    
                                        if ( $sdg_image = get_field('eruahaus_sdg_image', 'eruahaus-sdg_' . $sdg->term_id) ) {
                                            // echo '<pre>';
                                            // var_dump($sdg_image);
                                            // echo '</pre>';
                                            echo '<img class="" src="'.$sdg_image["sizes"]["thumbnail"].'" style="width: 100px; height: 100px;" />';
                                        }
                                    }
                                }
                            }
                            if ( $focus_areas ) {
                                echo '<focus-areas id="project-focus-areas" style="display: block; margin: 20px 0 0 0;">';
                                echo '<strong>' . __('Focus areas:', 'erua') . '</strong> ';
                                if ( is_array($focus_areas) ) {
                                    foreach ( $focus_areas as $key => $fa ) {
                                        $separator = ( $key === array_key_last($focus_areas) ) ? '' : ', ';
                                
                                        echo '<span class="project-focus-area"><a href="' . site_url('/') . $eruahaus_project_focus_area_taxonomy->rewrite['slug'] . '/' . $fa->slug . '">'. $fa->name .'</a>' . $separator . '</span>' ;
                                    }
                                }
                                echo '</focus-areas>';
                            }

                            ?>
                        </div>
                        <!-- <aside style="padding: 15px; margin-bottom: 30px; border: 1px solid #999;"> -->
                            <?php                            
                            //echo '<div><strong>Year</strong>: ' . get_the_date( 'Y' ) . '</div>';
                            ?>
                        <!-- </aside> -->
                        <?php get_template_part( 'template-parts/single', 'eruahaus-project' ); ?>
                    </div>
                </article>
        <?php
                endwhile;
            } else {
                get_template_part( 'no-results', 'index' );
            }
            //comments_template();
        }
        ?>
        </div>
        <div class="post-sidebar large-3 col">
            <?php flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php flatsome_sidebar_classes(); ?>" role="complementary">
                <?php do_action( 'before_sidebar' ); ?>
                <?php if ( ! dynamic_sidebar( 'eruahaus-sidebar' ) ) : ?>
                <?php endif; // end sidebar widget area ?>
            </div>
            <?php flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div>
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
