<div class="entry-content single-page">
    <h2 id="job-description"><?php _e('Description', 'erua'); ?></h2>

    <?php the_content(); ?>

    <?php
    global $job_opportunity_type, $job_opportunity_provider, $job_opportunity_fields, $job_opportunity_domains, $job_opportunity_profiles, $job_opportunity_keywords, $job_opportunity_other_important_information, $job_opportunities_page_url;

    if ( $job_opportunity_type ) {
        echo '<h2 id="job-type">' .__('Job Type', 'erua') . '</h2>';
        if ( $job_opportunities_page_url ) {
            echo '<p><a href="'.$job_opportunities_page_url.'?job_type='.$job_opportunity_type[0]->term_id.'">' . $job_opportunity_type[0]->name . '</a></p>';
        }
        else {
            echo '<p>' . $job_opportunity_type[0]->name . '</p>';
        }
    }

    if ( $job_opportunity_provider ) {
        echo '<h2 id="job-provider">' .__('Job Provider (Institution/Agency/Organization)', 'erua') . '</h2>';
        if ( $job_opportunities_page_url ) {
            echo '<p><a href="'.$job_opportunities_page_url.'?job_provider='.$job_opportunity_provider[0]->term_id.'">' . $job_opportunity_provider[0]->name . '</a></p>';
        }
        else {
            echo '<p>' . $job_opportunity_provider[0]->name . '</p>';
        }
    }

    if ( $job_opportunity_fields ) {
        //global $job_opportunity_field_taxonomy;
        echo '<job-fields id="job-fields" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Fields (Policy/sectors)', 'erua') . '</h2>';
        if ( is_array($job_opportunity_fields) ) {
            foreach ( $job_opportunity_fields as $key => $field ) {
                $separator = ( $key === array_key_last($job_opportunity_fields) ) ? '' : ', ';
    
                if ( $job_opportunities_page_url ) {
                    echo '<span class="job-field"><a href="' . $job_opportunities_page_url . '?job_fields='.$field->term_id.'">'. $field->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="job-field"><a href="' . site_url('/') . $job_opportunity_field_taxonomy->rewrite['slug'] . '/' . $field->slug . '">'. $field->name .'</a>' . $separator . '</span>';
                    echo '<span class="job-field">' . $field->name . $separator . '</span>';
                }
            }
        }
        echo '</job-fields>';
    }

    if ( $job_opportunity_domains ) {
        //global $job_opportunity_domain_taxonomy;
        echo '<job-domains id="job-domains" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Domains', 'erua') . '</h2>';
        if ( is_array($job_opportunity_domains) ) {
            foreach ( $job_opportunity_domains as $key => $domain ) {
                $separator = ( $key === array_key_last($job_opportunity_domains) ) ? '' : ', ';
    
                if ( $job_opportunities_page_url ) {
                    echo '<span class="job-domain"><a href="' . $job_opportunities_page_url . '?job_domains='.$domain->term_id.'">'. $domain->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="job-domain"><a href="' . site_url('/') . $job_opportunity_domain_taxonomy->rewrite['slug'] . '/' . $domain->slug . '">'. $domain->name .'</a>' . $separator . '</span>';
                    echo '<span class="job-domain">' . $domain->name . $separator . '</span>';
                }
            }
        }
        echo '</job-domains>';
    }

    if ( $job_opportunity_profiles ) {
        //global $job_opportunity_profile_taxonomy;
        echo '<job-profiles id="job-profiles" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Job Profiles', 'erua') . '</h2>';
        if ( is_array($job_opportunity_profiles) ) {
            foreach ( $job_opportunity_profiles as $key => $profile ) {
                $separator = ( $key === array_key_last($job_opportunity_profiles) ) ? '' : ', ';
    
                if ( $job_opportunities_page_url ) {
                    echo '<span class="job-profile"><a href="' . $job_opportunities_page_url . '?job_profiles='.$profile->term_id.'">'. $profile->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="job-profile"><a href="' . site_url('/') . $job_opportunity_profile_taxonomy->rewrite['slug'] . '/' . $profile->slug . '">'. $profile->name .'</a>' . $separator . '</span>';
                    echo '<span class="job-profile">' . $profile->name . $separator . '</span>';
                }
            }
        }
        echo '</job-profiles>';
    }

    if ( $job_opportunity_other_important_information ) {
        echo '<h2 id="job-important-info">' .__('Other important information', 'erua') . '</h2>';
        echo '<p>' . $job_opportunity_other_important_information . '</p>';
    }

    if ( $job_opportunity_keywords ) {
        //global $job_opportunity_keyword_tags;
        echo '<keywords id="job-keywords" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Keywords', 'erua') . '</h2>';
        if ( is_array($job_opportunity_keywords) ) {
            foreach ( $job_opportunity_keywords as $key => $keyword ) {
                $separator = ( $key === array_key_last($job_opportunity_keywords) ) ? '' : ', ';
    
                if ( $job_opportunities_page_url ) {
                    echo '<span class="job-keyword job-tag"><a href="' . $job_opportunities_page_url . '?keyword_tag='.$keyword->term_id.'">'. $keyword->name .'</a>' . $separator . '</span>';
                }
                else {
                    //echo '<span class="job-keyword job-tag"><a href="' . site_url('/') . $job_opportunity_keyword_tags->rewrite['slug'] . '/' . $keyword->slug . '">'. $keyword->name .'</a>' . $separator . '</span>';
                    echo '<span class="job-keyword job-tag"><a href="#">'. $keyword->name .'</a>' . $separator . '</span>';
                }
            }
        }
        echo '</keywords>';
    }
    ?>

    <?php
    wp_link_pages();
    ?>

    <?php if ( get_theme_mod( 'blog_share', 1 ) ) {
        // SHARE ICONS
        echo '<div class="blog-share text-center">';
        echo '<div class="is-divider medium"></div>';
        echo do_shortcode( '[share]' );
        echo '</div>';
    } ?>
</div>

<?php if ( get_theme_mod( 'blog_single_footer_meta', 1 ) ) : ?>
    <footer class="entry-meta text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
        <?php
        /* translators: used between list items, there is a space after the comma */
        $category_list = get_the_category_list( __( ', ', 'flatsome' ) );

        /* translators: used between list items, there is a space after the comma */
        $tag_list = get_the_tag_list( '', __( ', ', 'flatsome' ) );


        // But this blog has loads of categories so we should probably display them here.
        if ( '' != $tag_list ) {
            $meta_text = __( 'This entry was posted in %1$s and tagged %2$s.', 'flatsome' );
        } else {
            $meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'flatsome' );
        }

        printf( $meta_text, $category_list, $tag_list, get_permalink(), the_title_attribute( 'echo=0' ) );
        ?>
    </footer>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_author_box', 1 ) ) : ?>
    <div class="entry-author author-box">
        <div class="flex-row align-top">
            <div class="flex-col mr circle">
                <div class="blog-author-image">
                    <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'flatsome_author_bio_avatar_size', 90 ) ); ?>
                </div>
            </div>
            <div class="flex-col flex-grow">
                <h5 class="author-name uppercase pt-half">
                    <?php the_author_meta( 'display_name' ); ?>
                </h5>
                <p class="author-desc small"><?php the_author_meta( 'description' ); ?></p>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_single_next_prev_nav', 1 ) ) :
    flatsome_content_nav( 'nav-below' );
endif; ?>
